% Generate Npoint Gassian clusters for m-bit parity problems, and write to a file
clear; clf;
colors = [ 'vr'; 'og'; 'sb'; 'xm'; 'dc'; '<k';  '>r'; '.g'; 'vb'; 'om'; 'sc'; 'xk';'vr'; 'og'; 'sb'; 'xm'];   % Specify colors and marker types
lattice='n';
Npoint = 50;  
sig=0.02;			% dispersion		
ns=1;			%  start from ns=1; to drop first vertex ns=2

m=4;			% for m-bit parity
N2=2^m;			
%				generate all bits
p=[];				%  generate all points around hypercube corner
for k=1:N2+1-ns
	cen(k,:) = bitget(k-1,[1:m]) ;
	p = [p;  GaussMultiDimPoints(cen(k,:), sig, Npoint)]; 
end;
cen

figure(4);clf
W = figinit2D(m,lattice);
y = p*W'; 

Npall=(N2-ns+1)*Npoint; 
x=[];
for k=1:Npall
kk=floor((k-1)/Npoint)+1;
par=bitget(sum(cen(kk,:)),1);				% check parity bit of the sum of bits in the string
plot(y(k,1), y(k,2), colors(par+1,:)); hold on;
x=[x; [p(k,:),[par,1-par]]];					%  add parity here
% x=[x; [p(k,:),cen(kk,:)]];				%  add target vertex
end 

%  	Format for Gaussian clusters
        fid = fopen('par4a.dat','w');
if(m==2)
        fprintf(fid,'%6.2f\t  %6.2f\t  %2.0f  %2.0f  \n',x');				%   m=2
elseif(m==3)
x=sortrows(x,4);
        fprintf(fid,'%6.2f\t  %6.2f\t  %6.2f\t  %2.0f  %2.0f \n',x');			%   m=3
elseif(m==4)
        fprintf(fid,'%6.2f\t  %6.2f\t  %6.2f\t  %6.2f\t %2.0f %2.0f  \n',x');	%   m=4
else
disp(['Sorry not yet implemented'])
end
	fclose(fid);
