function out = Norm11(Data,Ncol,Nrow)
% Normalize to have Data(:,k) in [-1,+1] for each row

for d=1:Ncol
        mn = min(Data(:,d));			% min column value 
        mx = max(Data(:,d));			% max column value 
        md = (mn+mx)/2;				% (min+max)/2  
        nf  = max(0.000001,(mx-mn)/2);	% column range
        out(:,d) = (Data(:,d) - md)./nf;
end

