function [Z1,Z2] = fda2(Points,nclass,ndim)
%	FDA for nclass = 2 classes only

if(nclass~=2)
   error('This FDA version only for 2 classes! ');
   return;
end

npsize=size(Points);
N=npsize(1);								% no of points

class1=find(Points(:,ndim+1)==1);
nelc1=length(class1);					% number of elements per class
m1=mean(Points(class1,1:ndim));			% calculate means for each feature and each class 
var1=var(Points(class1,1:ndim));			% calculate means for each feature and each class 
%
class2=find(Points(:,ndim+2)==1);
nelc2=length(class2);					% number of elements per class
m2=mean(Points(class2,1:ndim));			% calculate means for each feature and each class 
var2=var(Points(class2,1:ndim));			% calculate means for each feature and each class 
%
mm=mean(Points(:,1:ndim));
%									% calculate SB - between-class scatter
%SB=(m1-m2)' * (m1-m2); 				% original Fisher - unstable, good for one direction only!
%
pert=0.01*sqrt([1:ndim]);
									% To stabilize it add some perturbations to the means
SB=nelc1*(m1-mm)' * (m1-mm)+nelc2*(m2-mm)' * (m2-mm);

m1n = m1+pert.*var1; m2n = m2- pert.*var2;
SB=SB+nelc1*(m1n-mm)' * (m1n-mm)+nelc2*(m2n-mm)' * (m2n-mm); 
m1n = m1 -pert.*var1; m2n = m2+pert.*var2;
SB=SB+nelc1*(m1n-mm)' * (m1n-mm)+nelc2*(m2n-mm)' * (m2n-mm); 
m1n = m1 +pert.*var1; m2n = m2+pert.*var2;
SB=SB+nelc1*(m1n-mm)' * (m1n-mm)+nelc2*(m2n-mm)' * (m2n-mm); 
m1n = m1 -pert.*var1; m2n = m2-pert.*var2;
SB=SB+nelc1*(m1n-mm)' * (m1n-mm)+nelc2*(m2n-mm)' * (m2n-mm); 

SB=SB/5;								% rescale SB by Npb
										% calculate SI - in-class scatter

SI=(nelc1/N)*(Points(class1,1:ndim)-ones(nelc1,1)*m1)' * (Points(class1,1:ndim)-ones(nelc1,1)*m1) + ... 
     (nelc2/N)*(Points(class2,1:ndim)-ones(nelc2,1)*m2)' * (Points(class2,1:ndim)-ones(nelc2,1)*m2);

% SIB=(SI^-1)*SB;					%  unstable, inverse ill defined

SIB=pinv(SI)*SB;					%  pseudoinverse

[eigv,eigval] = eigs(SIB,2,'LM');

%maxsb=max(max(SB)); maxsi=max(max(SI))

[ev1,i1]=max(max(eigval));
[ev2,i2]=min(max(eigval));

disp(['FDA eigenvalues:  ', num2str(ev1), '   ', num2str(ev2)])

Z1=eigv(:,i1);
Z2=eigv(:,i2);

[zmax1,iz1]=max(abs(Z1));					% find unique signs of eigenvectors
[zmax2,iz2]=max(abs(Z2)); 

Z1=sign(Z1(iz1))*Z1; 
Z2=sign(Z2(iz2))*Z2; 

Z12=Z1'*Z2;				% check orthogonality
disp(['FDA <Z1|Z2> = ', num2str(Z12)])
%