function [Z1,Z2] = fda3(Points,nclass,ndim)
%	FDA for nclass = 2 classes only

if(nclass~=2)
   error('This FDA version only for 2 classes! ');
   return;
end

npsize=size(Points);
N=npsize(1);								% no of points

%									for 2 classes codes are 0 1, 1 0, but only 1-st is checked
class1=find(Points(:,ndim+1)==1);
nelc1=length(class1);					% number of elements per class
m1=mean(Points(class1,1:ndim));			% calculate means for each feature and each class 
%
class2=find(Points(:,ndim+1)~=1);
nelc2=length(class2);					% number of elements per class
m2=mean(Points(class2,1:ndim));			% calculate means for each feature and each class 
%
mm=mean(Points(:,1:ndim));				% mean of all points

disp(['FDA1 elem in C1:  ', num2str(nelc1), '  in C2   ', num2str(nelc2)])
disp(['FDA1 means  C1:  ', num2str(m1)])
disp(['FDA1 means  C2:  ', num2str(m2)])

% Stabilize by shifting means if they are too close? 
m12=sum(abs(m1-m2));
if (m12<0.03)
m2=m2+0.02*ones(1,ndim);
disp(['Mean of m2 shifted by 0.1 because the difference was ',num2str(m12)])
end 
%									% calculate SB - between-class scatter
%SB=(m1-m2)' * (m1-m2); 				% original Fisher - unstable, good for one direction only!
%
SB=nelc1*(m1-mm)' * (m1-mm)+nelc2*(m2-mm)' * (m2-mm);

										% calculate SI - in-class scatter

SI=(nelc1/N)*(Points(class1,1:ndim)-ones(nelc1,1)*m1)' * (Points(class1,1:ndim)-ones(nelc1,1)*m1) + ... 
     (nelc2/N)*(Points(class2,1:ndim)-ones(nelc2,1)*m2)' * (Points(class2,1:ndim)-ones(nelc2,1)*m2);

% SIB=(SI^-1)*SB;					%  unstable, inverse ill defined

SIB=pinv(SI)*SB;					%  pseudoinverse

[Z1,ev1] = eigs(SIB,1,'LM');			%  one FDA direction is OK

%maxsb=max(max(SB)); maxsi=max(max(SI))

%  project data on Z1 
y1=Points(:,1:ndim)*Z1;		% projected points
yc=Points(:,ndim+1);		% labels
%  sort y1 and labels
[y1s,labs] = sort(y1);
%  find those that have both neighbors from other class, store them in Points2
y1cl=yc(labs);				% labels of sorted points

nd2=0;	
reg=2e-01; 
disp(['Selection for FDA2 is based on interval  ', num2str(reg)]) 
%disp(['Selection for FDA2 is  based on 1 wrong neighbor']) 
%disp(['Interval for FDA2 is  based on 2 wrong neighbors']) 

%					Different choices: one neighbor on left or right; or two, or one in region +/-reg
for k=2:N-1
% 				interval [y1s(k)-reg,y1s(k)+reg]; labels y1cl(k)
ycurr=y1s(k); 
yclass=y1cl(k);
kreg=find(ycurr-reg < y1s & y1s<ycurr+reg);
lcurr=y1cl(kreg);						% classes of those X projected to the interval [ycurr-reg, ycurr+reg]
ncurr=size(lcurr);
if(ncurr>0 & sum(abs(lcurr-yclass))~=0)		%  if not all points in the region are from yclass
%if (yclass~=y1cl(k-1) | yclass~=y1cl(k+1))   % one neighbor
%if (yclass~=y1cl(k-1) & yclass~=y1cl(k+1))  % both neighbors

	Points2(nd2+1,:)=Points(labs(k),:);
	nd2=nd2+1;
end; end;

% use Points2 to find the best FDA direction.

if(nd2>0)
class1=find(Points2(:,ndim+1)==1);
nelc1=length(class1);					% number of elements per class
m1=mean(Points2(class1,1:ndim));			% calculate means for each feature and each class 
%
class2=find(Points2(:,ndim+1)~=1);
nelc2=length(class2);					% number of elements per class
m2=mean(Points2(class2,1:ndim));			% calculate means for each feature and each class 
%
mm=mean(Points2(:,1:ndim));

disp(['FDA2 elem in C1:  ', num2str(nelc1), '  in C2   ', num2str(nelc2)])
disp(['FDA2 means  C1:  ', num2str(m1)])
disp(['FDA2 means  C2:  ', num2str(m2)])

%									% calculate SB - between-class scatter
%SB=(m1-m2)' * (m1-m2); 				% original Fisher - unstable, good for one direction only!
%
SB=nelc1*(m1-mm)' * (m1-mm)+nelc2*(m2-mm)' * (m2-mm);

										% calculate SI - in-class scatter

SI=(nelc1/N)*(Points2(class1,1:ndim)-ones(nelc1,1)*m1)' * (Points2(class1,1:ndim)-ones(nelc1,1)*m1) + ... 
     (nelc2/N)*(Points2(class2,1:ndim)-ones(nelc2,1)*m2)' * (Points2(class2,1:ndim)-ones(nelc2,1)*m2);

% SIB=(SI^-1)*SB;					%  unstable, inverse ill defined

SIB=pinv(SI)*SB;					%  pseudoinverse

[Z2,ev2] = eigs(SIB,1,'LM');			%  second FDA direction

else			% if (nd>0)
Z2=Z1; ev2=ev1;
end

disp(['FDA eigenvalues:  ', num2str(ev1), '   ', num2str(ev2)])


[zmax1,iz1]=max(abs(Z1));					% find unique signs of eigenvectors
[zmax2,iz2]=max(abs(Z2)); 

Z1=sign(Z1(iz1))*Z1; 
Z2=sign(Z2(iz2))*Z2; 

Z11=Z1'*Z1;				% check orthonormality
disp(['FDA <Z1|Z1> = ', num2str(Z11)])
Z22=Z2'*Z2;				% check orthonormality
disp(['FDA <Z2|Z2> = ', num2str(Z22)])
Z12=Z1'*Z2;				% check orthogonality
disp(['FDA <Z1|Z2> = ', num2str(Z12)])
%