function W = fdacube(N,npl);
figure(3); clf;
format short g;

nclass=2; ndim=N;
N2=2^N;
%				generate all bit strings, without 0
for k=1:N2-1
	Points(k,:) = bitget(k,[1:N]);
end;
%Points(N2,:)=zeros(1,N);  					% include [0,0...0] at the end 

par=bitget(sum(Points'),1)';					% add parity
Points=[Points, par, 1-par];

[Z1,Z2]=fda2(Points,nclass,ndim);					% FDA returns 2 components
disp(['FDA first vector        ' num2str(Z1')])
disp(['FDA second vector  ' num2str(Z2')])

Points(N2,:)=[zeros(1,N), 1, 0];  					% include [0,0...0] at the end 

yp=Points(:,1:N)*[Z1,Z2];


ymin=min(yp(:,1))-0.1; ymax=max(yp(:,1))+0.1;
ymin2=min(yp(:,2))-0.1; ymax2=max(yp(:,2))+0.1;
axis([ymin, ymax, ymin2, ymax2]);  hold on

class1=find(Points(:,N+1)==1);
class2=find(Points(:,N+2)==1);

plot(yp(class1,1),yp(class1,2), 'or', 'MarkerSize',5); hold on;
plot(yp(class2,1),yp(class2,2), 'sg', 'MarkerSize',5); hold on;

%		Test - show 1 point, npl
plot(yp(npl,1),yp(npl,2), '.r', 'MarkerSize',15); hold on;

% 			Connect lines differing on one bit
for k=2:N2
for l=1:k-1
dkl=sum(abs(Points(k,1:N)-Points(l,1:N)));
if(round(dkl)==1)
	plot([yp(k,1),yp(l,1)],[yp(k,2),yp(l,2)], '-k'); hold on;
end;  % if
end; end;

format short g
disp(['Marked point:  '  num2str(Points(npl,1:N))])
disp(['Projected point:  ' num2str(yp(npl,:))])
