function W = fdatest(npl);
format short g;
nclass=2;				% only for 2 classes

%  Lancet 11, par3 3, par4 4, heartstatlog 13, iris 4, thyrc12  21, archeo12  26. 
nin=21;
DS = DataSetLoad('thyrc12.dat',nin);
disp('Loaded: thyrc12 data')  

Points=[DS.Inputs,DS.Desired];

npsize=size(Points);
N=npsize(1);
ndim=nin; 						% no of features

disp(['Number of vectors  ', num2str(N), '   n of features  ', num2str(ndim)])

Datan = Norm11(DS.Inputs,ndim,N);		%  Normalize
Points=[Datan,DS.Desired];				%  Normalized + Classes

%[Z1,Z2]=fda1(Points,nclass,ndim);%  without stabilization, only 1 direction OK
%[Z1,Z2]=fda2(Points,nclass,ndim);%  with means perturbed
[Z1,Z2]=fda3(Points,nclass,ndim);	%  with selection of points that have >2 neighbors among 10 from the wrong class
yp=Points(:,1:ndim)*[Z1,Z2];

%find(yp(:,2)>0.5)
printfda;

disp(['Eigenvector 1 '])
fprintf(1,'%6.3f\t',Z1);
fprintf(1,'\n');

ymin=min(yp(:,1))-0.1; ymax=max(yp(:,1))+0.1;
ymin2=min(yp(:,2))-0.1; ymax2=max(yp(:,2))+0.1;
axis([ymin, ymax, ymin2, ymax2]);  hold on

class1=find(Points(:,ndim+1)==1);
class2=find(Points(:,ndim+1)~=1);

figure(1); clf
plot(yp(class1,1),yp(class1,2), 'or', 'MarkerSize',8); hold on;
plot(yp(class2,1),yp(class2,2), 'xb', 'MarkerSize',8); hold on;
title('FDA')

pce=pca(Datan);
npce=sqrt(pce'*pce);
pnpce=pce/npce;
pvar=pnpce(1)^2+pnpce(2)^2;

disp(['PCA eigenvalues:  ', num2str(pnpce(1)), '   ', num2str(pnpce(2))])
disp(['Percent variance in PCA: ', num2str(pvar)])

%		Test - show 3 points, npl : npl+2
plot(yp(npl,1),yp(npl,2), '.r', 'MarkerSize',15); hold on;
%plot(yp(npl+1,1),yp(npl+1,2), '.g', 'MarkerSize',15); hold on;
%plot(yp(npl+2,1),yp(npl+2,2), '.b', 'MarkerSize',15); hold on;

%format short g
%[Points(npl:npl+2,:), yp(npl:npl+2,:)]

%%%%%%%%%%%%        PCA projection part
[pce,Wt]=pca(Datan,2);
yp = Datan* Wt ;

figure(2); clf; 
plot(yp(class1,1),yp(class1,2), 'or', 'MarkerSize',8); hold on;
plot(yp(class2,1),yp(class2,2), 'xb', 'MarkerSize',8); hold on;
title('PCA')

%		Test - show 3 points, npl : npl+2
plot(yp(npl,1),yp(npl,2), '.r', 'MarkerSize',15); hold on;
%plot(yp(npl+1,1),yp(npl+1,2), '.g', 'MarkerSize',15); hold on;
%plot(yp(npl+2,1),yp(npl+2,2), '.b', 'MarkerSize',15); hold on;

%format short g
%[Points(npl:npl+2,:), yp(npl:npl+2,:)]

%x=[yp, Points(:,ndim+1)];
%fid = fopen('hearstatlog.dat','w');
%fprintf(fid,'%8.5f\t  %8.5f\t  %2.0f  \n',x');				%   m=2
%fclose(fid);

%Points(N2,:)=zeros(1,N);  % add [0,0...0] for drawing
%yp(N2,:)=[0,0];  % add [0,0] for drawing

% 			Connect lines differing on one bit
%for k=2:N2
%for l=1:k-1
%dkl=sum(abs(Points(k,:)-Points(l,:)));
%if(round(dkl)==1)
%	plot([yp(k,1),yp(l,1)],[yp(k,2),yp(l,2)], '-k'); hold on;
%end;  % if
%end; end;


%N2=2^N;
%				generate all bit strings, without 0
%for k=1:N2-1
%	Points(k,:) = bitget(k,[1:N]);
%end;
%Points(N2,:)=2*ones(1,N);  % include [0,0...0] at the end 
%Points=Points+0.0*randn(N2-1,N);  			% add some noise
%klasy=bitget(round(sum(Points')),1)+1;			%  assign class labels

