package pl.umk.fizyka.cubegl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.os.Bundle;

import android.app.Activity;
import android.view.Menu;

import android.opengl.GLSurfaceView;
import android.opengl.GLU;

public class MainActivity extends Activity {

	GLSurfaceView glView = null;
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_main);
        
        GLSurfaceView view = new GLSurfaceView(this);
        view.setRenderer(new OpenGLRenderer());
        setContentView(view);
        
        glView = view; //?????
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
    @Override
    protected void onPause()
    {
    	super.onPause();
    	glView.onPause();
    }
    
    @Override
    protected void onResume()
    {
    	super.onResume();
    	glView.onResume();
    }
}

class OpenGLRenderer implements android.opengl.GLSurfaceView.Renderer
{

	public void onSurfaceCreated(GL10 gl, EGLConfig config) 
	{
		gl.glShadeModel(GL10.GL_SMOOTH);
		
		//takie samo, jak domyslne
		gl.glClearDepthf(1.0f);
		gl.glEnable(GL10.GL_DEPTH_TEST);
		gl.glDepthFunc(GL10.GL_LEQUAL);
		gl.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT, GL10.GL_NICEST);
		gl.glDisable(GL10.GL_DITHER);
		
		inicjujBuforWerteksow();
		
		oswietlenie(gl);
	}

	private void ustawieniaSceny(GL10 gl, int szer, int wys)
	{
		gl.glViewport(0, 0, szer, wys);
		
		gl.glMatrixMode(GL10.GL_PROJECTION);
		gl.glLoadIdentity();
		GLU.gluPerspective(gl, 45.0f, (float)szer/(float)wys, 0.1f, 100.0f);
		gl.glMatrixMode(GL10.GL_MODELVIEW);
		GLU.gluLookAt(
				gl, 
				0, 0, 7.5f, //polozenie kamery 
				0, 0, 0, 
				0, 1, 0);		
	}

	public void onSurfaceChanged(GL10 gl, int width, int height) 
	{
		if(height==0) height=1;
		ustawieniaSceny(gl,width,height);		
	}

	private final float a = 1f;
	private float[] tablicaWerteksow=
		{
			//tylnia
			a,-a,-a,
			-a,-a,-a,
			a,a,-a,
			-a,a,-a,			
			//przednia
			-a,-a,a,
			a,-a,a,
			-a,a,a,
			a,a,a,			

			//prawa
			a,-a,a,
			a,-a,-a,
			a,a,a,
			a,a,-a,
			//lewa
			-a,-a,-a,
			-a,-a,a,
			-a,a,-a,
			-a,a,a,

			//gorna
			-a,a,a,
			a,a,a,
			-a,a,-a,
			a,a,-a,
			//dolna
			-a,-a,-a,
			a,-a,-a,
			-a,-a,a,
			a,-a,a
		};
	
	private FloatBuffer buforWerteksow_Polozenie;
	
	private void inicjujBuforWerteksow()
	{
		ByteBuffer vbb=ByteBuffer.allocateDirect(tablicaWerteksow.length*4); //float = 4 bajty
		vbb.order(ByteOrder.nativeOrder());
		buforWerteksow_Polozenie = vbb.asFloatBuffer();
		buforWerteksow_Polozenie.put(tablicaWerteksow);
		buforWerteksow_Polozenie.position(0);
	}
	
	float kolory[][] =
		{
			{1f,0f,0f,1f}, //tylnia
			{1f,0f,0f,1f}, //przednia
			{0f,1f,0f,1f}, //prawa
			{0f,1f,0f,1f}, //lewa
			{0f,0f,1f,1f}, //gorna
			{0f,0f,1f,1f}, //tylnia
		};
	
	float normalne[][] = 
		{
		{0,0,-1}, //tylnia
		{0,0,1}, //przednia
		{1,0,0}, //prawa
		{-1,0,0}, //lewa
		{0,1,0}, //gorna
		{0,-1,0}, //dolna			
		};
	
	private void rysujSzescian(GL10 gl,float krawedz,boolean kolor)
	{
		gl.glFrontFace(GL10.GL_CCW);
		gl.glEnable(GL10.GL_CULL_FACE);
		gl.glCullFace(GL10.GL_BACK);
		
		if(krawedz!=1.0f) gl.glScalef(krawedz, krawedz, krawedz);
		
		gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);
		gl.glVertexPointer(3, GL10.GL_FLOAT, 0, buforWerteksow_Polozenie);
		
		if(!kolor) gl.glColor4f(1f, 1f, 1f, 1f);
		
		for(int i=0; i<6;++i)
		{
			gl.glNormal3f(normalne[i][0], normalne[i][1], normalne[i][2]);
			if(kolor) gl.glColor4f(kolory[i][0], kolory[i][1], kolory[i][2], kolory[i][3]);
			gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, i*4, 4);			
		}
		
		gl.glDisableClientState(GL10.GL_VERTEX_ARRAY);
		gl.glDisable(GL10.GL_CULL_FACE);
	}
	
	public void onDrawFrame(GL10 gl) 
	{
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);

		gl.glRotatef(5f, 0f, 1f, 0.1f);
		
		gl.glPushMatrix();
		rysujSzescian(gl, 1, false);
		gl.glPopMatrix();
	}
	

	private void oswietlenie(GL10 gl)
	{
		gl.glEnable(GL10.GL_LIGHTING);
		
		mlecznaZarowka(gl,GL10.GL_LIGHT1);
		reflektor(gl, GL10.GL_LIGHT2);
	}
	
	private void mlecznaZarowka(GL10 gl,int zrodloSwiatla)
	{
		final float kolor_rozproszone[]={0.5f,0.5f,0.5f,1.0f};
		gl.glLightfv(zrodloSwiatla, GL10.GL_DIFFUSE, kolor_rozproszone,0);
		gl.glEnable(zrodloSwiatla);
	}
	
	private void reflektor(GL10 gl,int zrodloSwiatla)
	{
		final float kolor_rozproszone[]={0.3f,0.3f,0.3f,1.0f};
		final float kolor_reflektora[]={1f,1f,1f,1.0f};
		final float pozycja[] = {0f,-10f,10f,1f};
		final float szerokosc_wiazki = 60f;
		gl.glLightfv(zrodloSwiatla, GL10.GL_POSITION, pozycja,0);
		gl.glLightfv(zrodloSwiatla, GL10.GL_DIFFUSE, kolor_rozproszone,0);
		gl.glLightfv(zrodloSwiatla, GL10.GL_SPECULAR, kolor_reflektora,0);
		gl.glLightf(zrodloSwiatla, GL10.GL_SPOT_CUTOFF, szerokosc_wiazki);
		gl.glEnable(zrodloSwiatla);
	}
}