#pragma once

#ifndef __gxopengl_opengl_h__
	#define __gxopengl_opengl_h__

#include "../foundation.h"
#include "glcore.h"


#pragma comment(lib, "opengl32.lib")

#ifdef __cplusplus
extern "C" {
#endif

/* ## GL_VERSION_1_0 ## */
extern void APIENTRY glCullFace (GLenum mode);
extern void APIENTRY glFrontFace (GLenum mode);
extern void APIENTRY glHint (GLenum target, GLenum mode);
extern void APIENTRY glLineWidth (GLfloat width);
extern void APIENTRY glPointSize (GLfloat size);
extern void APIENTRY glPolygonMode (GLenum face, GLenum mode);
extern void APIENTRY glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
extern void APIENTRY glTexParameterf (GLenum target, GLenum pname, GLfloat param);
extern void APIENTRY glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
extern void APIENTRY glTexParameteri (GLenum target, GLenum pname, GLint param);
extern void APIENTRY glTexParameteriv (GLenum target, GLenum pname, const GLint *params);
extern void APIENTRY glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY glDrawBuffer (GLenum mode);
extern void APIENTRY glClear (GLbitfield mask);
extern void APIENTRY glClearColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void APIENTRY glClearStencil (GLint s);
extern void APIENTRY glClearDepth (GLdouble depth);
extern void APIENTRY glStencilMask (GLuint mask);
extern void APIENTRY glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
extern void APIENTRY glDepthMask (GLboolean flag);
extern void APIENTRY glDisable (GLenum cap);
extern void APIENTRY glEnable (GLenum cap);
extern void APIENTRY glFinish (void);
extern void APIENTRY glFlush (void);
extern void APIENTRY glBlendFunc (GLenum sfactor, GLenum dfactor);
extern void APIENTRY glLogicOp (GLenum opcode);
extern void APIENTRY glStencilFunc (GLenum func, GLint ref, GLuint mask);
extern void APIENTRY glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
extern void APIENTRY glDepthFunc (GLenum func);
extern void APIENTRY glPixelStoref (GLenum pname, GLfloat param);
extern void APIENTRY glPixelStorei (GLenum pname, GLint param);
extern void APIENTRY glReadBuffer (GLenum mode);
extern void APIENTRY glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
extern void APIENTRY glGetBooleanv (GLenum pname, GLboolean *params);
extern void APIENTRY glGetDoublev (GLenum pname, GLdouble *params);
extern GLenum APIENTRY glGetError (void);
extern void APIENTRY glGetFloatv (GLenum pname, GLfloat *params);
extern void APIENTRY glGetIntegerv (GLenum pname, GLint *params);
extern const GLubyte * APIENTRY glGetString (GLenum name);
extern void APIENTRY glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void APIENTRY glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void APIENTRY glGetTexParameteriv (GLenum target, GLenum pname, GLint *params);
extern void APIENTRY glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
extern void APIENTRY glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
extern GLboolean APIENTRY glIsEnabled (GLenum cap);
extern void APIENTRY glDepthRange (GLdouble near, GLdouble far);
extern void APIENTRY glViewport (GLint x, GLint y, GLsizei width, GLsizei height);

/* ## GL_VERSION_1_1 ## */
extern void APIENTRY glDrawArrays (GLenum mode, GLint first, GLsizei count);
extern void APIENTRY glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
extern void APIENTRY glGetPointerv (GLenum pname, GLvoid* *params);
extern void APIENTRY glPolygonOffset (GLfloat factor, GLfloat units);
extern void APIENTRY glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
extern void APIENTRY glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void APIENTRY glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void APIENTRY glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void APIENTRY glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY glBindTexture (GLenum target, GLuint texture);
extern void APIENTRY glDeleteTextures (GLsizei n, const GLuint *textures);
extern void APIENTRY glGenTextures (GLsizei n, GLuint *textures);
extern GLboolean APIENTRY glIsTexture (GLuint texture);

/* ## GL_VERSION_1_2 ## */
GX_API void APIENTRY glBlendColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GX_API void APIENTRY glBlendEquation (GLenum mode);
GX_API void APIENTRY glDrawRangeElements (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
GX_API void APIENTRY glTexImage3D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
GX_API void APIENTRY glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
GX_API void APIENTRY glCopyTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);

/* ## GL_VERSION_1_3 ## */
GX_API void APIENTRY glActiveTexture (GLenum texture);
GX_API void APIENTRY glSampleCoverage (GLfloat value, GLboolean invert);
GX_API void APIENTRY glCompressedTexImage3D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glCompressedTexImage1D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glCompressedTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glCompressedTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
GX_API void APIENTRY glGetCompressedTexImage (GLenum target, GLint level, GLvoid *img);

/* ## GL_VERSION_1_4 ## */
GX_API void APIENTRY glBlendFuncSeparate (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
GX_API void APIENTRY glMultiDrawArrays (GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount);
GX_API void APIENTRY glMultiDrawElements (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount);
GX_API void APIENTRY glPointParameterf (GLenum pname, GLfloat param);
GX_API void APIENTRY glPointParameterfv (GLenum pname, const GLfloat *params);
GX_API void APIENTRY glPointParameteri (GLenum pname, GLint param);
GX_API void APIENTRY glPointParameteriv (GLenum pname, const GLint *params);

/* ## GL_VERSION_1_5 ## */
GX_API void APIENTRY glGenQueries (GLsizei n, GLuint *ids);
GX_API void APIENTRY glDeleteQueries (GLsizei n, const GLuint *ids);
GX_API GLboolean APIENTRY glIsQuery (GLuint id);
GX_API void APIENTRY glBeginQuery (GLenum target, GLuint id);
GX_API void APIENTRY glEndQuery (GLenum target);
GX_API void APIENTRY glGetQueryiv (GLenum target, GLenum pname, GLint *params);
GX_API void APIENTRY glGetQueryObjectiv (GLuint id, GLenum pname, GLint *params);
GX_API void APIENTRY glGetQueryObjectuiv (GLuint id, GLenum pname, GLuint *params);
GX_API void APIENTRY glBindBuffer (GLenum target, GLuint buffer);
GX_API void APIENTRY glDeleteBuffers (GLsizei n, const GLuint *buffers);
GX_API void APIENTRY glGenBuffers (GLsizei n, GLuint *buffers);
GX_API GLboolean APIENTRY glIsBuffer (GLuint buffer);
GX_API void APIENTRY glBufferData (GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
GX_API void APIENTRY glBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
GX_API void APIENTRY glGetBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data);
GX_API GLvoid* APIENTRY glMapBuffer (GLenum target, GLenum access);
GX_API GLboolean APIENTRY glUnmapBuffer (GLenum target);
GX_API void APIENTRY glGetBufferParameteriv (GLenum target, GLenum pname, GLint *params);
GX_API void APIENTRY glGetBufferPointerv (GLenum target, GLenum pname, GLvoid* *params);

/* ## GL_VERSION_2_0 ## */
GX_API void APIENTRY glBlendEquationSeparate (GLenum modeRGB, GLenum modeAlpha);
GX_API void APIENTRY glDrawBuffers (GLsizei n, const GLenum *bufs);
GX_API void APIENTRY glStencilOpSeparate (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
GX_API void APIENTRY glStencilFuncSeparate (GLenum face, GLenum func, GLint ref, GLuint mask);
GX_API void APIENTRY glStencilMaskSeparate (GLenum face, GLuint mask);
GX_API void APIENTRY glAttachShader (GLuint program, GLuint shader);
GX_API void APIENTRY glBindAttribLocation (GLuint program, GLuint index, const GLchar *name);
GX_API void APIENTRY glCompileShader (GLuint shader);
GX_API GLuint APIENTRY glCreateProgram (void);
GX_API GLuint APIENTRY glCreateShader (GLenum type);
GX_API void APIENTRY glDeleteProgram (GLuint program);
GX_API void APIENTRY glDeleteShader (GLuint shader);
GX_API void APIENTRY glDetachShader (GLuint program, GLuint shader);
GX_API void APIENTRY glDisableVertexAttribArray (GLuint index);
GX_API void APIENTRY glEnableVertexAttribArray (GLuint index);
GX_API void APIENTRY glGetActiveAttrib (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
GX_API void APIENTRY glGetActiveUniform (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
GX_API void APIENTRY glGetAttachedShaders (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj);
GX_API GLint APIENTRY glGetAttribLocation (GLuint program, const GLchar *name);
GX_API void APIENTRY glGetProgramiv (GLuint program, GLenum pname, GLint *params);
GX_API void APIENTRY glGetProgramInfoLog (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
GX_API void APIENTRY glGetShaderiv (GLuint shader, GLenum pname, GLint *params);
GX_API void APIENTRY glGetShaderInfoLog (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
GX_API void APIENTRY glGetShaderSource (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
GX_API GLint APIENTRY glGetUniformLocation (GLuint program, const GLchar *name);
GX_API void APIENTRY glGetUniformfv (GLuint program, GLint location, GLfloat *params);
GX_API void APIENTRY glGetUniformiv (GLuint program, GLint location, GLint *params);
GX_API void APIENTRY glGetVertexAttribdv (GLuint index, GLenum pname, GLdouble *params);
GX_API void APIENTRY glGetVertexAttribfv (GLuint index, GLenum pname, GLfloat *params);
GX_API void APIENTRY glGetVertexAttribiv (GLuint index, GLenum pname, GLint *params);
GX_API void APIENTRY glGetVertexAttribPointerv (GLuint index, GLenum pname, GLvoid* *pointer);
GX_API GLboolean APIENTRY glIsProgram (GLuint program);
GX_API GLboolean APIENTRY glIsShader (GLuint shader);
GX_API void APIENTRY glLinkProgram (GLuint program);
GX_API void APIENTRY glShaderSource (GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length);
GX_API void APIENTRY glUseProgram (GLuint program);
GX_API void APIENTRY glUniform1f (GLint location, GLfloat v0);
GX_API void APIENTRY glUniform2f (GLint location, GLfloat v0, GLfloat v1);
GX_API void APIENTRY glUniform3f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
GX_API void APIENTRY glUniform4f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
GX_API void APIENTRY glUniform1i (GLint location, GLint v0);
GX_API void APIENTRY glUniform2i (GLint location, GLint v0, GLint v1);
GX_API void APIENTRY glUniform3i (GLint location, GLint v0, GLint v1, GLint v2);
GX_API void APIENTRY glUniform4i (GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
GX_API void APIENTRY glUniform1fv (GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glUniform2fv (GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glUniform3fv (GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glUniform4fv (GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glUniform1iv (GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glUniform2iv (GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glUniform3iv (GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glUniform4iv (GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glUniformMatrix2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glValidateProgram (GLuint program);
GX_API void APIENTRY glVertexAttrib1d (GLuint index, GLdouble x);
GX_API void APIENTRY glVertexAttrib1dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttrib1f (GLuint index, GLfloat x);
GX_API void APIENTRY glVertexAttrib1fv (GLuint index, const GLfloat *v);
GX_API void APIENTRY glVertexAttrib1s (GLuint index, GLshort x);
GX_API void APIENTRY glVertexAttrib1sv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttrib2d (GLuint index, GLdouble x, GLdouble y);
GX_API void APIENTRY glVertexAttrib2dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttrib2f (GLuint index, GLfloat x, GLfloat y);
GX_API void APIENTRY glVertexAttrib2fv (GLuint index, const GLfloat *v);
GX_API void APIENTRY glVertexAttrib2s (GLuint index, GLshort x, GLshort y);
GX_API void APIENTRY glVertexAttrib2sv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttrib3d (GLuint index, GLdouble x, GLdouble y, GLdouble z);
GX_API void APIENTRY glVertexAttrib3dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttrib3f (GLuint index, GLfloat x, GLfloat y, GLfloat z);
GX_API void APIENTRY glVertexAttrib3fv (GLuint index, const GLfloat *v);
GX_API void APIENTRY glVertexAttrib3s (GLuint index, GLshort x, GLshort y, GLshort z);
GX_API void APIENTRY glVertexAttrib3sv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttrib4Nbv (GLuint index, const GLbyte *v);
GX_API void APIENTRY glVertexAttrib4Niv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttrib4Nsv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttrib4Nub (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
GX_API void APIENTRY glVertexAttrib4Nubv (GLuint index, const GLubyte *v);
GX_API void APIENTRY glVertexAttrib4Nuiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttrib4Nusv (GLuint index, const GLushort *v);
GX_API void APIENTRY glVertexAttrib4bv (GLuint index, const GLbyte *v);
GX_API void APIENTRY glVertexAttrib4d (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GX_API void APIENTRY glVertexAttrib4dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttrib4f (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
GX_API void APIENTRY glVertexAttrib4fv (GLuint index, const GLfloat *v);
GX_API void APIENTRY glVertexAttrib4iv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttrib4s (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
GX_API void APIENTRY glVertexAttrib4sv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttrib4ubv (GLuint index, const GLubyte *v);
GX_API void APIENTRY glVertexAttrib4uiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttrib4usv (GLuint index, const GLushort *v);
GX_API void APIENTRY glVertexAttribPointer (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);

/* ## GL_VERSION_2_1 ## */
GX_API void APIENTRY glUniformMatrix2x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix3x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix2x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix4x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix3x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glUniformMatrix4x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

/* ## GL_VERSION_3_0 ## */
GX_API void APIENTRY glColorMaski (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
GX_API void APIENTRY glGetBooleani_v (GLenum target, GLuint index, GLboolean *data);
GX_API void APIENTRY glGetIntegeri_v (GLenum target, GLuint index, GLint *data);
GX_API void APIENTRY glEnablei (GLenum target, GLuint index);
GX_API void APIENTRY glDisablei (GLenum target, GLuint index);
GX_API GLboolean APIENTRY glIsEnabledi (GLenum target, GLuint index);
GX_API void APIENTRY glBeginTransformFeedback (GLenum primitiveMode);
GX_API void APIENTRY glEndTransformFeedback (void);
GX_API void APIENTRY glBindBufferRange (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
GX_API void APIENTRY glBindBufferBase (GLenum target, GLuint index, GLuint buffer);
GX_API void APIENTRY glTransformFeedbackVaryings (GLuint program, GLsizei count, const GLchar* const *varyings, GLenum bufferMode);
GX_API void APIENTRY glGetTransformFeedbackVarying (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
GX_API void APIENTRY glClampColor (GLenum target, GLenum clamp);
GX_API void APIENTRY glBeginConditionalRender (GLuint id, GLenum mode);
GX_API void APIENTRY glEndConditionalRender (void);
GX_API void APIENTRY glVertexAttribIPointer (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
GX_API void APIENTRY glGetVertexAttribIiv (GLuint index, GLenum pname, GLint *params);
GX_API void APIENTRY glGetVertexAttribIuiv (GLuint index, GLenum pname, GLuint *params);
GX_API void APIENTRY glVertexAttribI1i (GLuint index, GLint x);
GX_API void APIENTRY glVertexAttribI2i (GLuint index, GLint x, GLint y);
GX_API void APIENTRY glVertexAttribI3i (GLuint index, GLint x, GLint y, GLint z);
GX_API void APIENTRY glVertexAttribI4i (GLuint index, GLint x, GLint y, GLint z, GLint w);
GX_API void APIENTRY glVertexAttribI1ui (GLuint index, GLuint x);
GX_API void APIENTRY glVertexAttribI2ui (GLuint index, GLuint x, GLuint y);
GX_API void APIENTRY glVertexAttribI3ui (GLuint index, GLuint x, GLuint y, GLuint z);
GX_API void APIENTRY glVertexAttribI4ui (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
GX_API void APIENTRY glVertexAttribI1iv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttribI2iv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttribI3iv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttribI4iv (GLuint index, const GLint *v);
GX_API void APIENTRY glVertexAttribI1uiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttribI2uiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttribI3uiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttribI4uiv (GLuint index, const GLuint *v);
GX_API void APIENTRY glVertexAttribI4bv (GLuint index, const GLbyte *v);
GX_API void APIENTRY glVertexAttribI4sv (GLuint index, const GLshort *v);
GX_API void APIENTRY glVertexAttribI4ubv (GLuint index, const GLubyte *v);
GX_API void APIENTRY glVertexAttribI4usv (GLuint index, const GLushort *v);
GX_API void APIENTRY glGetUniformuiv (GLuint program, GLint location, GLuint *params);
GX_API void APIENTRY glBindFragDataLocation (GLuint program, GLuint color, const GLchar *name);
GX_API GLint APIENTRY glGetFragDataLocation (GLuint program, const GLchar *name);
GX_API void APIENTRY glUniform1ui (GLint location, GLuint v0);
GX_API void APIENTRY glUniform2ui (GLint location, GLuint v0, GLuint v1);
GX_API void APIENTRY glUniform3ui (GLint location, GLuint v0, GLuint v1, GLuint v2);
GX_API void APIENTRY glUniform4ui (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
GX_API void APIENTRY glUniform1uiv (GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glUniform2uiv (GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glUniform3uiv (GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glUniform4uiv (GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glTexParameterIiv (GLenum target, GLenum pname, const GLint *params);
GX_API void APIENTRY glTexParameterIuiv (GLenum target, GLenum pname, const GLuint *params);
GX_API void APIENTRY glGetTexParameterIiv (GLenum target, GLenum pname, GLint *params);
GX_API void APIENTRY glGetTexParameterIuiv (GLenum target, GLenum pname, GLuint *params);
GX_API void APIENTRY glClearBufferiv (GLenum buffer, GLint drawbuffer, const GLint *value);
GX_API void APIENTRY glClearBufferuiv (GLenum buffer, GLint drawbuffer, const GLuint *value);
GX_API void APIENTRY glClearBufferfv (GLenum buffer, GLint drawbuffer, const GLfloat *value);
GX_API void APIENTRY glClearBufferfi (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
GX_API const GLubyte * APIENTRY glGetStringi (GLenum name, GLuint index);

/* ## GL_VERSION_3_1 ## */
GX_API void APIENTRY glDrawArraysInstanced (GLenum mode, GLint first, GLsizei count, GLsizei instancecount);
GX_API void APIENTRY glDrawElementsInstanced (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount);
GX_API void APIENTRY glTexBuffer (GLenum target, GLenum internalformat, GLuint buffer);
GX_API void APIENTRY glPrimitiveRestartIndex (GLuint index);

/* ## GL_VERSION_3_2 ## */
GX_API void APIENTRY glGetInteger64i_v (GLenum target, GLuint index, GLint64 *data);
GX_API void APIENTRY glGetBufferParameteri64v (GLenum target, GLenum pname, GLint64 *params);
GX_API void APIENTRY glFramebufferTexture (GLenum target, GLenum attachment, GLuint texture, GLint level);

/* ## GL_VERSION_3_3 ## */
GX_API void APIENTRY glVertexAttribDivisor (GLuint index, GLuint divisor);

/* ## GL_VERSION_4_0 ## */
GX_API void APIENTRY glMinSampleShading (GLfloat value);
GX_API void APIENTRY glBlendEquationi (GLuint buf, GLenum mode);
GX_API void APIENTRY glBlendEquationSeparatei (GLuint buf, GLenum modeRGB, GLenum modeAlpha);
GX_API void APIENTRY glBlendFunci (GLuint buf, GLenum src, GLenum dst);
GX_API void APIENTRY glBlendFuncSeparatei (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

/* ## GL_VERSION_4_1 ## */

/* ## GL_VERSION_4_2 ## */

/* ## GL_VERSION_4_3 ## */

/* ## GL_ARB_depth_buffer_float ## */

/* ## GL_ARB_framebuffer_object ## */
GX_API GLboolean APIENTRY glIsRenderbuffer (GLuint renderbuffer);
GX_API void APIENTRY glBindRenderbuffer (GLenum target, GLuint renderbuffer);
GX_API void APIENTRY glDeleteRenderbuffers (GLsizei n, const GLuint *renderbuffers);
GX_API void APIENTRY glGenRenderbuffers (GLsizei n, GLuint *renderbuffers);
GX_API void APIENTRY glRenderbufferStorage (GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
GX_API void APIENTRY glGetRenderbufferParameteriv (GLenum target, GLenum pname, GLint *params);
GX_API GLboolean APIENTRY glIsFramebuffer (GLuint framebuffer);
GX_API void APIENTRY glBindFramebuffer (GLenum target, GLuint framebuffer);
GX_API void APIENTRY glDeleteFramebuffers (GLsizei n, const GLuint *framebuffers);
GX_API void APIENTRY glGenFramebuffers (GLsizei n, GLuint *framebuffers);
GX_API GLenum APIENTRY glCheckFramebufferStatus (GLenum target);
GX_API void APIENTRY glFramebufferTexture1D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
GX_API void APIENTRY glFramebufferTexture2D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
GX_API void APIENTRY glFramebufferTexture3D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
GX_API void APIENTRY glFramebufferRenderbuffer (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
GX_API void APIENTRY glGetFramebufferAttachmentParameteriv (GLenum target, GLenum attachment, GLenum pname, GLint *params);
GX_API void APIENTRY glGenerateMipmap (GLenum target);
GX_API void APIENTRY glBlitFramebuffer (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
GX_API void APIENTRY glRenderbufferStorageMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
GX_API void APIENTRY glFramebufferTextureLayer (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);

/* ## GL_ARB_framebuffer_sRGB ## */

/* ## GL_ARB_half_float_vertex ## */

/* ## GL_ARB_map_buffer_range ## */
GX_API GLvoid* APIENTRY glMapBufferRange (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
GX_API void APIENTRY glFlushMappedBufferRange (GLenum target, GLintptr offset, GLsizeiptr length);

/* ## GL_ARB_texture_compression_rgtc ## */

/* ## GL_ARB_texture_rg ## */

/* ## GL_ARB_vertex_array_object ## */
GX_API void APIENTRY glBindVertexArray (GLuint array);
GX_API void APIENTRY glDeleteVertexArrays (GLsizei n, const GLuint *arrays);
GX_API void APIENTRY glGenVertexArrays (GLsizei n, GLuint *arrays);
GX_API GLboolean APIENTRY glIsVertexArray (GLuint array);

/* ## GL_ARB_uniform_buffer_object ## */
GX_API void APIENTRY glGetUniformIndices (GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices);
GX_API void APIENTRY glGetActiveUniformsiv (GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
GX_API void APIENTRY glGetActiveUniformName (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
GX_API GLuint APIENTRY glGetUniformBlockIndex (GLuint program, const GLchar *uniformBlockName);
GX_API void APIENTRY glGetActiveUniformBlockiv (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
GX_API void APIENTRY glGetActiveUniformBlockName (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
GX_API void APIENTRY glUniformBlockBinding (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);

/* ## GL_ARB_copy_buffer ## */
GX_API void APIENTRY glCopyBufferSubData (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);

/* ## GL_ARB_depth_clamp ## */

/* ## GL_ARB_draw_elements_base_vertex ## */
GX_API void APIENTRY glDrawElementsBaseVertex (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
GX_API void APIENTRY glDrawRangeElementsBaseVertex (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
GX_API void APIENTRY glDrawElementsInstancedBaseVertex (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex);
GX_API void APIENTRY glMultiDrawElementsBaseVertex (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex);

/* ## GL_ARB_fragment_coord_conventions ## */

/* ## GL_ARB_provoking_vertex ## */
GX_API void APIENTRY glProvokingVertex (GLenum mode);

/* ## GL_ARB_seamless_cube_map ## */

/* ## GL_ARB_sync ## */
GX_API GLsync APIENTRY glFenceSync (GLenum condition, GLbitfield flags);
GX_API GLboolean APIENTRY glIsSync (GLsync sync);
GX_API void APIENTRY glDeleteSync (GLsync sync);
GX_API GLenum APIENTRY glClientWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout);
GX_API void APIENTRY glWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout);
GX_API void APIENTRY glGetInteger64v (GLenum pname, GLint64 *params);
GX_API void APIENTRY glGetSynciv (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);

/* ## GL_ARB_texture_multisample ## */
GX_API void APIENTRY glTexImage2DMultisample (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
GX_API void APIENTRY glTexImage3DMultisample (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
GX_API void APIENTRY glGetMultisamplefv (GLenum pname, GLuint index, GLfloat *val);
GX_API void APIENTRY glSampleMaski (GLuint index, GLbitfield mask);

/* ## GL_ARB_vertex_array_bgra ## */

/* ## GL_ARB_draw_buffers_blend ## */
GX_API void APIENTRY glBlendEquationiARB (GLuint buf, GLenum mode);
GX_API void APIENTRY glBlendEquationSeparateiARB (GLuint buf, GLenum modeRGB, GLenum modeAlpha);
GX_API void APIENTRY glBlendFunciARB (GLuint buf, GLenum src, GLenum dst);
GX_API void APIENTRY glBlendFuncSeparateiARB (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

/* ## GL_ARB_sample_shading ## */
GX_API void APIENTRY glMinSampleShadingARB (GLfloat value);

/* ## GL_ARB_texture_cube_map_array ## */

/* ## GL_ARB_texture_gather ## */

/* ## GL_ARB_texture_query_lod ## */

/* ## GL_ARB_shading_language_include ## */
GX_API void APIENTRY glNamedStringARB (GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string);
GX_API void APIENTRY glDeleteNamedStringARB (GLint namelen, const GLchar *name);
GX_API void APIENTRY glCompileShaderIncludeARB (GLuint shader, GLsizei count, const GLchar* *path, const GLint *length);
GX_API GLboolean APIENTRY glIsNamedStringARB (GLint namelen, const GLchar *name);
GX_API void APIENTRY glGetNamedStringARB (GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string);
GX_API void APIENTRY glGetNamedStringivARB (GLint namelen, const GLchar *name, GLenum pname, GLint *params);

/* ## GL_ARB_texture_compression_bptc ## */

/* ## GL_ARB_blend_func_extended ## */
GX_API void APIENTRY glBindFragDataLocationIndexed (GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
GX_API GLint APIENTRY glGetFragDataIndex (GLuint program, const GLchar *name);

/* ## GL_ARB_explicit_attrib_location ## */

/* ## GL_ARB_occlusion_query2 ## */

/* ## GL_ARB_sampler_objects ## */
GX_API void APIENTRY glGenSamplers (GLsizei count, GLuint *samplers);
GX_API void APIENTRY glDeleteSamplers (GLsizei count, const GLuint *samplers);
GX_API GLboolean APIENTRY glIsSampler (GLuint sampler);
GX_API void APIENTRY glBindSampler (GLuint unit, GLuint sampler);
GX_API void APIENTRY glSamplerParameteri (GLuint sampler, GLenum pname, GLint param);
GX_API void APIENTRY glSamplerParameteriv (GLuint sampler, GLenum pname, const GLint *param);
GX_API void APIENTRY glSamplerParameterf (GLuint sampler, GLenum pname, GLfloat param);
GX_API void APIENTRY glSamplerParameterfv (GLuint sampler, GLenum pname, const GLfloat *param);
GX_API void APIENTRY glSamplerParameterIiv (GLuint sampler, GLenum pname, const GLint *param);
GX_API void APIENTRY glSamplerParameterIuiv (GLuint sampler, GLenum pname, const GLuint *param);
GX_API void APIENTRY glGetSamplerParameteriv (GLuint sampler, GLenum pname, GLint *params);
GX_API void APIENTRY glGetSamplerParameterIiv (GLuint sampler, GLenum pname, GLint *params);
GX_API void APIENTRY glGetSamplerParameterfv (GLuint sampler, GLenum pname, GLfloat *params);
GX_API void APIENTRY glGetSamplerParameterIuiv (GLuint sampler, GLenum pname, GLuint *params);

/* ## GL_ARB_shader_bit_encoding ## */

/* ## GL_ARB_texture_rgb10_a2ui ## */

/* ## GL_ARB_texture_swizzle ## */

/* ## GL_ARB_timer_query ## */
GX_API void APIENTRY glQueryCounter (GLuint id, GLenum target);
GX_API void APIENTRY glGetQueryObjecti64v (GLuint id, GLenum pname, GLint64 *params);
GX_API void APIENTRY glGetQueryObjectui64v (GLuint id, GLenum pname, GLuint64 *params);

/* ## GL_ARB_vertex_type_2_10_10_10_rev ## */
GX_API void APIENTRY glVertexP2ui (GLenum type, GLuint value);
GX_API void APIENTRY glVertexP2uiv (GLenum type, const GLuint *value);
GX_API void APIENTRY glVertexP3ui (GLenum type, GLuint value);
GX_API void APIENTRY glVertexP3uiv (GLenum type, const GLuint *value);
GX_API void APIENTRY glVertexP4ui (GLenum type, GLuint value);
GX_API void APIENTRY glVertexP4uiv (GLenum type, const GLuint *value);
GX_API void APIENTRY glTexCoordP1ui (GLenum type, GLuint coords);
GX_API void APIENTRY glTexCoordP1uiv (GLenum type, const GLuint *coords);
GX_API void APIENTRY glTexCoordP2ui (GLenum type, GLuint coords);
GX_API void APIENTRY glTexCoordP2uiv (GLenum type, const GLuint *coords);
GX_API void APIENTRY glTexCoordP3ui (GLenum type, GLuint coords);
GX_API void APIENTRY glTexCoordP3uiv (GLenum type, const GLuint *coords);
GX_API void APIENTRY glTexCoordP4ui (GLenum type, GLuint coords);
GX_API void APIENTRY glTexCoordP4uiv (GLenum type, const GLuint *coords);
GX_API void APIENTRY glMultiTexCoordP1ui (GLenum texture, GLenum type, GLuint coords);
GX_API void APIENTRY glMultiTexCoordP1uiv (GLenum texture, GLenum type, const GLuint *coords);
GX_API void APIENTRY glMultiTexCoordP2ui (GLenum texture, GLenum type, GLuint coords);
GX_API void APIENTRY glMultiTexCoordP2uiv (GLenum texture, GLenum type, const GLuint *coords);
GX_API void APIENTRY glMultiTexCoordP3ui (GLenum texture, GLenum type, GLuint coords);
GX_API void APIENTRY glMultiTexCoordP3uiv (GLenum texture, GLenum type, const GLuint *coords);
GX_API void APIENTRY glMultiTexCoordP4ui (GLenum texture, GLenum type, GLuint coords);
GX_API void APIENTRY glMultiTexCoordP4uiv (GLenum texture, GLenum type, const GLuint *coords);
GX_API void APIENTRY glNormalP3ui (GLenum type, GLuint coords);
GX_API void APIENTRY glNormalP3uiv (GLenum type, const GLuint *coords);
GX_API void APIENTRY glColorP3ui (GLenum type, GLuint color);
GX_API void APIENTRY glColorP3uiv (GLenum type, const GLuint *color);
GX_API void APIENTRY glColorP4ui (GLenum type, GLuint color);
GX_API void APIENTRY glColorP4uiv (GLenum type, const GLuint *color);
GX_API void APIENTRY glSecondaryColorP3ui (GLenum type, GLuint color);
GX_API void APIENTRY glSecondaryColorP3uiv (GLenum type, const GLuint *color);
GX_API void APIENTRY glVertexAttribP1ui (GLuint index, GLenum type, GLboolean normalized, GLuint value);
GX_API void APIENTRY glVertexAttribP1uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
GX_API void APIENTRY glVertexAttribP2ui (GLuint index, GLenum type, GLboolean normalized, GLuint value);
GX_API void APIENTRY glVertexAttribP2uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
GX_API void APIENTRY glVertexAttribP3ui (GLuint index, GLenum type, GLboolean normalized, GLuint value);
GX_API void APIENTRY glVertexAttribP3uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
GX_API void APIENTRY glVertexAttribP4ui (GLuint index, GLenum type, GLboolean normalized, GLuint value);
GX_API void APIENTRY glVertexAttribP4uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);

/* ## GL_ARB_draw_indirect ## */
GX_API void APIENTRY glDrawArraysIndirect (GLenum mode, const GLvoid *indirect);
GX_API void APIENTRY glDrawElementsIndirect (GLenum mode, GLenum type, const GLvoid *indirect);

/* ## GL_ARB_gpu_shader5 ## */

/* ## GL_ARB_gpu_shader_fp64 ## */
GX_API void APIENTRY glUniform1d (GLint location, GLdouble x);
GX_API void APIENTRY glUniform2d (GLint location, GLdouble x, GLdouble y);
GX_API void APIENTRY glUniform3d (GLint location, GLdouble x, GLdouble y, GLdouble z);
GX_API void APIENTRY glUniform4d (GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GX_API void APIENTRY glUniform1dv (GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glUniform2dv (GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glUniform3dv (GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glUniform4dv (GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix2x3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix2x4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix3x2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix3x4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix4x2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glUniformMatrix4x3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glGetUniformdv (GLuint program, GLint location, GLdouble *params);

/* ## GL_ARB_shader_subroutine ## */
GX_API GLint APIENTRY glGetSubroutineUniformLocation (GLuint program, GLenum shadertype, const GLchar *name);
GX_API GLuint APIENTRY glGetSubroutineIndex (GLuint program, GLenum shadertype, const GLchar *name);
GX_API void APIENTRY glGetActiveSubroutineUniformiv (GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values);
GX_API void APIENTRY glGetActiveSubroutineUniformName (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
GX_API void APIENTRY glGetActiveSubroutineName (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
GX_API void APIENTRY glUniformSubroutinesuiv (GLenum shadertype, GLsizei count, const GLuint *indices);
GX_API void APIENTRY glGetUniformSubroutineuiv (GLenum shadertype, GLint location, GLuint *params);
GX_API void APIENTRY glGetProgramStageiv (GLuint program, GLenum shadertype, GLenum pname, GLint *values);

/* ## GL_ARB_tessellation_shader ## */
GX_API void APIENTRY glPatchParameteri (GLenum pname, GLint value);
GX_API void APIENTRY glPatchParameterfv (GLenum pname, const GLfloat *values);

/* ## GL_ARB_texture_buffer_object_rgb32 ## */

/* ## GL_ARB_transform_feedback2 ## */
GX_API void APIENTRY glBindTransformFeedback (GLenum target, GLuint id);
GX_API void APIENTRY glDeleteTransformFeedbacks (GLsizei n, const GLuint *ids);
GX_API void APIENTRY glGenTransformFeedbacks (GLsizei n, GLuint *ids);
GX_API GLboolean APIENTRY glIsTransformFeedback (GLuint id);
GX_API void APIENTRY glPauseTransformFeedback (void);
GX_API void APIENTRY glResumeTransformFeedback (void);
GX_API void APIENTRY glDrawTransformFeedback (GLenum mode, GLuint id);

/* ## GL_ARB_transform_feedback3 ## */
GX_API void APIENTRY glDrawTransformFeedbackStream (GLenum mode, GLuint id, GLuint stream);
GX_API void APIENTRY glBeginQueryIndexed (GLenum target, GLuint index, GLuint id);
GX_API void APIENTRY glEndQueryIndexed (GLenum target, GLuint index);
GX_API void APIENTRY glGetQueryIndexediv (GLenum target, GLuint index, GLenum pname, GLint *params);

/* ## GL_ARB_ES2_compatibility ## */
GX_API void APIENTRY glReleaseShaderCompiler (void);
GX_API void APIENTRY glShaderBinary (GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length);
GX_API void APIENTRY glGetShaderPrecisionFormat (GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision);
GX_API void APIENTRY glDepthRangef (GLfloat n, GLfloat f);
GX_API void APIENTRY glClearDepthf (GLfloat d);

/* ## GL_ARB_get_program_binary ## */
GX_API void APIENTRY glGetProgramBinary (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
GX_API void APIENTRY glProgramBinary (GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
GX_API void APIENTRY glProgramParameteri (GLuint program, GLenum pname, GLint value);

/* ## GL_ARB_separate_shader_objects ## */
GX_API void APIENTRY glUseProgramStages (GLuint pipeline, GLbitfield stages, GLuint program);
GX_API void APIENTRY glActiveShaderProgram (GLuint pipeline, GLuint program);
GX_API GLuint APIENTRY glCreateShaderProgramv (GLenum type, GLsizei count, const GLchar* const *strings);
GX_API void APIENTRY glBindProgramPipeline (GLuint pipeline);
GX_API void APIENTRY glDeleteProgramPipelines (GLsizei n, const GLuint *pipelines);
GX_API void APIENTRY glGenProgramPipelines (GLsizei n, GLuint *pipelines);
GX_API GLboolean APIENTRY glIsProgramPipeline (GLuint pipeline);
GX_API void APIENTRY glGetProgramPipelineiv (GLuint pipeline, GLenum pname, GLint *params);
GX_API void APIENTRY glProgramUniform1i (GLuint program, GLint location, GLint v0);
GX_API void APIENTRY glProgramUniform1iv (GLuint program, GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glProgramUniform1f (GLuint program, GLint location, GLfloat v0);
GX_API void APIENTRY glProgramUniform1fv (GLuint program, GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glProgramUniform1d (GLuint program, GLint location, GLdouble v0);
GX_API void APIENTRY glProgramUniform1dv (GLuint program, GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glProgramUniform1ui (GLuint program, GLint location, GLuint v0);
GX_API void APIENTRY glProgramUniform1uiv (GLuint program, GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glProgramUniform2i (GLuint program, GLint location, GLint v0, GLint v1);
GX_API void APIENTRY glProgramUniform2iv (GLuint program, GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glProgramUniform2f (GLuint program, GLint location, GLfloat v0, GLfloat v1);
GX_API void APIENTRY glProgramUniform2fv (GLuint program, GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glProgramUniform2d (GLuint program, GLint location, GLdouble v0, GLdouble v1);
GX_API void APIENTRY glProgramUniform2dv (GLuint program, GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glProgramUniform2ui (GLuint program, GLint location, GLuint v0, GLuint v1);
GX_API void APIENTRY glProgramUniform2uiv (GLuint program, GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glProgramUniform3i (GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
GX_API void APIENTRY glProgramUniform3iv (GLuint program, GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glProgramUniform3f (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
GX_API void APIENTRY glProgramUniform3fv (GLuint program, GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glProgramUniform3d (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2);
GX_API void APIENTRY glProgramUniform3dv (GLuint program, GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glProgramUniform3ui (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
GX_API void APIENTRY glProgramUniform3uiv (GLuint program, GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glProgramUniform4i (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
GX_API void APIENTRY glProgramUniform4iv (GLuint program, GLint location, GLsizei count, const GLint *value);
GX_API void APIENTRY glProgramUniform4f (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
GX_API void APIENTRY glProgramUniform4fv (GLuint program, GLint location, GLsizei count, const GLfloat *value);
GX_API void APIENTRY glProgramUniform4d (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3);
GX_API void APIENTRY glProgramUniform4dv (GLuint program, GLint location, GLsizei count, const GLdouble *value);
GX_API void APIENTRY glProgramUniform4ui (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
GX_API void APIENTRY glProgramUniform4uiv (GLuint program, GLint location, GLsizei count, const GLuint *value);
GX_API void APIENTRY glProgramUniformMatrix2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix2x3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix3x2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix2x4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix4x2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix3x4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix4x3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
GX_API void APIENTRY glProgramUniformMatrix2x3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix3x2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix2x4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix4x2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix3x4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glProgramUniformMatrix4x3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
GX_API void APIENTRY glValidateProgramPipeline (GLuint pipeline);
GX_API void APIENTRY glGetProgramPipelineInfoLog (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);

/* ## GL_ARB_vertex_attrib_64bit ## */
GX_API void APIENTRY glVertexAttribL1d (GLuint index, GLdouble x);
GX_API void APIENTRY glVertexAttribL2d (GLuint index, GLdouble x, GLdouble y);
GX_API void APIENTRY glVertexAttribL3d (GLuint index, GLdouble x, GLdouble y, GLdouble z);
GX_API void APIENTRY glVertexAttribL4d (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GX_API void APIENTRY glVertexAttribL1dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttribL2dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttribL3dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttribL4dv (GLuint index, const GLdouble *v);
GX_API void APIENTRY glVertexAttribLPointer (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
GX_API void APIENTRY glGetVertexAttribLdv (GLuint index, GLenum pname, GLdouble *params);

/* ## GL_ARB_viewport_array ## */
GX_API void APIENTRY glViewportArrayv (GLuint first, GLsizei count, const GLfloat *v);
GX_API void APIENTRY glViewportIndexedf (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
GX_API void APIENTRY glViewportIndexedfv (GLuint index, const GLfloat *v);
GX_API void APIENTRY glScissorArrayv (GLuint first, GLsizei count, const GLint *v);
GX_API void APIENTRY glScissorIndexed (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
GX_API void APIENTRY glScissorIndexedv (GLuint index, const GLint *v);
GX_API void APIENTRY glDepthRangeArrayv (GLuint first, GLsizei count, const GLdouble *v);
GX_API void APIENTRY glDepthRangeIndexed (GLuint index, GLdouble n, GLdouble f);
GX_API void APIENTRY glGetFloati_v (GLenum target, GLuint index, GLfloat *data);
GX_API void APIENTRY glGetDoublei_v (GLenum target, GLuint index, GLdouble *data);

/* ## GL_ARB_cl_event ## */
GX_API GLsync APIENTRY glCreateSyncFromCLeventARB (struct _cl_context * context, struct _cl_event * event, GLbitfield flags);

/* ## GL_ARB_debug_output ## */
GX_API void APIENTRY glDebugMessageControlARB (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
GX_API void APIENTRY glDebugMessageInsertARB (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
GX_API void APIENTRY glDebugMessageCallbackARB (GLDEBUGPROCARB callback, const GLvoid *userParam);
GX_API GLuint APIENTRY glGetDebugMessageLogARB (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);

/* ## GL_ARB_robustness ## */
GX_API GLenum APIENTRY glGetGraphicsResetStatusARB (void);
GX_API void APIENTRY glGetnTexImageARB (GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img);
GX_API void APIENTRY glReadnPixelsARB (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
GX_API void APIENTRY glGetnCompressedTexImageARB (GLenum target, GLint lod, GLsizei bufSize, GLvoid *img);
GX_API void APIENTRY glGetnUniformfvARB (GLuint program, GLint location, GLsizei bufSize, GLfloat *params);
GX_API void APIENTRY glGetnUniformivARB (GLuint program, GLint location, GLsizei bufSize, GLint *params);
GX_API void APIENTRY glGetnUniformuivARB (GLuint program, GLint location, GLsizei bufSize, GLuint *params);
GX_API void APIENTRY glGetnUniformdvARB (GLuint program, GLint location, GLsizei bufSize, GLdouble *params);

/* ## GL_ARB_shader_stencil_export ## */

/* ## GL_ARB_base_instance ## */
GX_API void APIENTRY glDrawArraysInstancedBaseInstance (GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance);
GX_API void APIENTRY glDrawElementsInstancedBaseInstance (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance);
GX_API void APIENTRY glDrawElementsInstancedBaseVertexBaseInstance (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance);

/* ## GL_ARB_shading_language_420pack ## */

/* ## GL_ARB_transform_feedback_instanced ## */
GX_API void APIENTRY glDrawTransformFeedbackInstanced (GLenum mode, GLuint id, GLsizei instancecount);
GX_API void APIENTRY glDrawTransformFeedbackStreamInstanced (GLenum mode, GLuint id, GLuint stream, GLsizei instancecount);

/* ## GL_ARB_compressed_texture_pixel_storage ## */

/* ## GL_ARB_conservative_depth ## */

/* ## GL_ARB_internalformat_query ## */
GX_API void APIENTRY glGetInternalformativ (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);

/* ## GL_ARB_map_buffer_alignment ## */

/* ## GL_ARB_shader_atomic_counters ## */
GX_API void APIENTRY glGetActiveAtomicCounterBufferiv (GLuint program, GLuint bufferIndex, GLenum pname, GLint *params);

/* ## GL_ARB_shader_image_load_store ## */
GX_API void APIENTRY glBindImageTexture (GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
GX_API void APIENTRY glMemoryBarrier (GLbitfield barriers);

/* ## GL_ARB_shading_language_packing ## */

/* ## GL_ARB_texture_storage ## */
GX_API void APIENTRY glTexStorage1D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
GX_API void APIENTRY glTexStorage2D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
GX_API void APIENTRY glTexStorage3D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
GX_API void APIENTRY glTextureStorage1DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
GX_API void APIENTRY glTextureStorage2DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
GX_API void APIENTRY glTextureStorage3DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);

/* ## GL_KHR_texture_compression_astc_ldr ## */

/* ## GL_KHR_debug ## */
GX_API void APIENTRY glDebugMessageControl (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
GX_API void APIENTRY glDebugMessageInsert (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
GX_API void APIENTRY glDebugMessageCallback (GLDEBUGPROC callback, const void *userParam);
GX_API GLuint APIENTRY glGetDebugMessageLog (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
GX_API void APIENTRY glPushDebugGroup (GLenum source, GLuint id, GLsizei length, const GLchar *message);
GX_API void APIENTRY glPopDebugGroup (void);
GX_API void APIENTRY glObjectLabel (GLenum identifier, GLuint name, GLsizei length, const GLchar *label);
GX_API void APIENTRY glGetObjectLabel (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label);
GX_API void APIENTRY glObjectPtrLabel (const void *ptr, GLsizei length, const GLchar *label);
GX_API void APIENTRY glGetObjectPtrLabel (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label);

/* ## GL_ARB_arrays_of_arrays ## */

/* ## GL_ARB_clear_buffer_object ## */
GX_API void APIENTRY glClearBufferData (GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data);
GX_API void APIENTRY glClearBufferSubData (GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
GX_API void APIENTRY glClearNamedBufferDataEXT (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data);
GX_API void APIENTRY glClearNamedBufferSubDataEXT (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, GLsizeiptr offset, GLsizeiptr size, const void *data);

/* ## GL_ARB_compute_shader ## */
GX_API void APIENTRY glDispatchCompute (GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
GX_API void APIENTRY glDispatchComputeIndirect (GLintptr indirect);

/* ## GL_ARB_copy_image ## */
GX_API void APIENTRY glCopyImageSubData (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);

/* ## GL_ARB_texture_view ## */
GX_API void APIENTRY glTextureView (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);

/* ## GL_ARB_vertex_attrib_binding ## */
GX_API void APIENTRY glBindVertexBuffer (GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
GX_API void APIENTRY glVertexAttribFormat (GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
GX_API void APIENTRY glVertexAttribIFormat (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
GX_API void APIENTRY glVertexAttribLFormat (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
GX_API void APIENTRY glVertexAttribBinding (GLuint attribindex, GLuint bindingindex);
GX_API void APIENTRY glVertexBindingDivisor (GLuint bindingindex, GLuint divisor);
GX_API void APIENTRY glVertexArrayBindVertexBufferEXT (GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
GX_API void APIENTRY glVertexArrayVertexAttribFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
GX_API void APIENTRY glVertexArrayVertexAttribIFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
GX_API void APIENTRY glVertexArrayVertexAttribLFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
GX_API void APIENTRY glVertexArrayVertexAttribBindingEXT (GLuint vaobj, GLuint attribindex, GLuint bindingindex);
GX_API void APIENTRY glVertexArrayVertexBindingDivisorEXT (GLuint vaobj, GLuint bindingindex, GLuint divisor);

/* ## GL_ARB_robustness_isolation ## */

/* ## GL_ARB_ES3_compatibility ## */

/* ## GL_ARB_explicit_uniform_location ## */

/* ## GL_ARB_fragment_layer_viewport ## */

/* ## GL_ARB_framebuffer_no_attachments ## */
GX_API void APIENTRY glFramebufferParameteri (GLenum target, GLenum pname, GLint param);
GX_API void APIENTRY glGetFramebufferParameteriv (GLenum target, GLenum pname, GLint *params);
GX_API void APIENTRY glNamedFramebufferParameteriEXT (GLuint framebuffer, GLenum pname, GLint param);
GX_API void APIENTRY glGetNamedFramebufferParameterivEXT (GLuint framebuffer, GLenum pname, GLint *params);

/* ## GL_ARB_internalformat_query2 ## */
GX_API void APIENTRY glGetInternalformati64v (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);

/* ## GL_ARB_invalidate_subdata ## */
GX_API void APIENTRY glInvalidateTexSubImage (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
GX_API void APIENTRY glInvalidateTexImage (GLuint texture, GLint level);
GX_API void APIENTRY glInvalidateBufferSubData (GLuint buffer, GLintptr offset, GLsizeiptr length);
GX_API void APIENTRY glInvalidateBufferData (GLuint buffer);
GX_API void APIENTRY glInvalidateFramebuffer (GLenum target, GLsizei numAttachments, const GLenum *attachments);
GX_API void APIENTRY glInvalidateSubFramebuffer (GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);

/* ## GL_ARB_multi_draw_indirect ## */
GX_API void APIENTRY glMultiDrawArraysIndirect (GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride);
GX_API void APIENTRY glMultiDrawElementsIndirect (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride);

/* ## GL_ARB_program_interface_query ## */
GX_API void APIENTRY glGetProgramInterfaceiv (GLuint program, GLenum programInterface, GLenum pname, GLint *params);
GX_API GLuint APIENTRY glGetProgramResourceIndex (GLuint program, GLenum programInterface, const GLchar *name);
GX_API void APIENTRY glGetProgramResourceName (GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name);
GX_API void APIENTRY glGetProgramResourceiv (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params);
GX_API GLint APIENTRY glGetProgramResourceLocation (GLuint program, GLenum programInterface, const GLchar *name);
GX_API GLint APIENTRY glGetProgramResourceLocationIndex (GLuint program, GLenum programInterface, const GLchar *name);

/* ## GL_ARB_robust_buffer_access_behavior ## */

/* ## GL_ARB_shader_image_size ## */

/* ## GL_ARB_shader_storage_buffer_object ## */
GX_API void APIENTRY glShaderStorageBlockBinding (GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);

/* ## GL_ARB_stencil_texturing ## */

/* ## GL_ARB_texture_buffer_range ## */
GX_API void APIENTRY glTexBufferRange (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
GX_API void APIENTRY glTextureBufferRangeEXT (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);

/* ## GL_ARB_texture_query_levels ## */

/* ## GL_ARB_texture_storage_multisample ## */
GX_API void APIENTRY glTexStorage2DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
GX_API void APIENTRY glTexStorage3DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
GX_API void APIENTRY glTextureStorage2DMultisampleEXT (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
GX_API void APIENTRY glTextureStorage3DMultisampleEXT (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);

/* ## GL_EXT_texture_filter_anisotropic ## */
#define GL_TEXTURE_MAX_ANISOTROPY_EXT		0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT	0x84FF

#ifdef __cplusplus
}
#endif

namespace Gx
{
	extern GX_API bool hasGL_version_1_2;
	extern GX_API bool hasGL_version_1_3;
	extern GX_API bool hasGL_version_1_4;
	extern GX_API bool hasGL_version_1_5;
	extern GX_API bool hasGL_version_2_0;
	extern GX_API bool hasGL_version_2_1;
	extern GX_API bool hasGL_version_3_0;
	extern GX_API bool hasGL_version_3_1;
	extern GX_API bool hasGL_version_3_2;
	extern GX_API bool hasGL_version_3_3;
	extern GX_API bool hasGL_version_4_0;
	extern GX_API bool hasGL_version_4_1;
	extern GX_API bool hasGL_version_4_2;
	extern GX_API bool hasGL_version_4_3;
	extern GX_API bool hasGL_ARB_depth_buffer_float;
	extern GX_API bool hasGL_ARB_framebuffer_object;
	extern GX_API bool hasGL_ARB_framebuffer_sRGB;
	extern GX_API bool hasGL_ARB_half_float_vertex;
	extern GX_API bool hasGL_ARB_map_buffer_range;
	extern GX_API bool hasGL_ARB_texture_compression_rgtc;
	extern GX_API bool hasGL_ARB_texture_rg;
	extern GX_API bool hasGL_ARB_vertex_array_object;
	extern GX_API bool hasGL_ARB_uniform_buffer_object;
	extern GX_API bool hasGL_ARB_copy_buffer;
	extern GX_API bool hasGL_ARB_depth_clamp;
	extern GX_API bool hasGL_ARB_draw_elements_base_vertex;
	extern GX_API bool hasGL_ARB_fragment_coord_conventions;
	extern GX_API bool hasGL_ARB_provoking_vertex;
	extern GX_API bool hasGL_ARB_seamless_cube_map;
	extern GX_API bool hasGL_ARB_sync;
	extern GX_API bool hasGL_ARB_texture_multisample;
	extern GX_API bool hasGL_ARB_vertex_array_bgra;
	extern GX_API bool hasGL_ARB_draw_buffers_blend;
	extern GX_API bool hasGL_ARB_sample_shading;
	extern GX_API bool hasGL_ARB_texture_cube_map_array;
	extern GX_API bool hasGL_ARB_texture_gather;
	extern GX_API bool hasGL_ARB_texture_query_lod;
	extern GX_API bool hasGL_ARB_shading_language_include;
	extern GX_API bool hasGL_ARB_texture_compression_bptc;
	extern GX_API bool hasGL_ARB_blend_func_extended;
	extern GX_API bool hasGL_ARB_explicit_attrib_location;
	extern GX_API bool hasGL_ARB_occlusion_query2;
	extern GX_API bool hasGL_ARB_sampler_objects;
	extern GX_API bool hasGL_ARB_shader_bit_encoding;
	extern GX_API bool hasGL_ARB_texture_rgb10_a2ui;
	extern GX_API bool hasGL_ARB_texture_swizzle;
	extern GX_API bool hasGL_ARB_timer_query;
	extern GX_API bool hasGL_ARB_vertex_type_2_10_10_10_rev;
	extern GX_API bool hasGL_ARB_draw_indirect;
	extern GX_API bool hasGL_ARB_gpu_shader5;
	extern GX_API bool hasGL_ARB_gpu_shader_fp64;
	extern GX_API bool hasGL_ARB_shader_subroutine;
	extern GX_API bool hasGL_ARB_tessellation_shader;
	extern GX_API bool hasGL_ARB_texture_buffer_object_rgb32;
	extern GX_API bool hasGL_ARB_transform_feedback2;
	extern GX_API bool hasGL_ARB_transform_feedback3;
	extern GX_API bool hasGL_ARB_ES2_compatibility;
	extern GX_API bool hasGL_ARB_get_program_binary;
	extern GX_API bool hasGL_ARB_separate_shader_objects;
	extern GX_API bool hasGL_ARB_shader_precision;
	extern GX_API bool hasGL_ARB_vertex_attrib_64bit;
	extern GX_API bool hasGL_ARB_viewport_array;
	extern GX_API bool hasGL_ARB_cl_event;
	extern GX_API bool hasGL_ARB_debug_output;
	extern GX_API bool hasGL_ARB_robustness;
	extern GX_API bool hasGL_ARB_shader_stencil_export;
	extern GX_API bool hasGL_ARB_base_instance;
	extern GX_API bool hasGL_ARB_shading_language_420pack;
	extern GX_API bool hasGL_ARB_transform_feedback_instanced;
	extern GX_API bool hasGL_ARB_compressed_texture_pixel_storage;
	extern GX_API bool hasGL_ARB_conservative_depth;
	extern GX_API bool hasGL_ARB_internalformat_query;
	extern GX_API bool hasGL_ARB_map_buffer_alignment;
	extern GX_API bool hasGL_ARB_shader_atomic_counters;
	extern GX_API bool hasGL_ARB_shader_image_load_store;
	extern GX_API bool hasGL_ARB_shading_language_packing;
	extern GX_API bool hasGL_ARB_texture_storage;
	extern GX_API bool hasGL_KHR_texture_compression_astc_ldr;
	extern GX_API bool hasGL_KHR_debug;
	extern GX_API bool hasGL_ARB_arrays_of_arrays;
	extern GX_API bool hasGL_ARB_clear_buffer_object;
	extern GX_API bool hasGL_ARB_compute_shader;
	extern GX_API bool hasGL_ARB_copy_image;
	extern GX_API bool hasGL_ARB_texture_view;
	extern GX_API bool hasGL_ARB_vertex_attrib_binding;
	extern GX_API bool hasGL_ARB_robustness_isolation;
	extern GX_API bool hasGL_ARB_ES3_compatibility;
	extern GX_API bool hasGL_ARB_explicit_uniform_location;
	extern GX_API bool hasGL_ARB_fragment_layer_viewport;
	extern GX_API bool hasGL_ARB_framebuffer_no_attachments;
	extern GX_API bool hasGL_ARB_internalformat_query2;
	extern GX_API bool hasGL_ARB_invalidate_subdata;
	extern GX_API bool hasGL_ARB_multi_draw_indirect;
	extern GX_API bool hasGL_ARB_program_interface_query;
	extern GX_API bool hasGL_ARB_robust_buffer_access_behavior;
	extern GX_API bool hasGL_ARB_shader_image_size;
	extern GX_API bool hasGL_ARB_shader_storage_buffer_object;
	extern GX_API bool hasGL_ARB_stencil_texturing;
	extern GX_API bool hasGL_ARB_texture_buffer_range;
	extern GX_API bool hasGL_ARB_texture_query_levels;
	extern GX_API bool hasGL_ARB_texture_storage_multisample;
	extern GX_API bool hasGL_EXT_texture_filter_anisotropic;

	GX_API bool hasGLExtension(const char* extensionName);

	GX_API void loadGLFuntions();

	GX_API void getGLVersion(int& major, int& minor);
	GX_API int getGLMajorVersion();
	GX_API int getGLMinorVersion();
}

#endif /* __gxopengl_opengl_h__ */