#pragma once

#ifndef __gx_material_h__
	#define __gx_material_h__

#include "foundation.h"
#include "color.h"

namespace Gx
{
	class Texture2D;

	class GX_API Material
	{
	public:
		Material();
		Material(const PxVec4& color);
		Material(Texture2D* texture);
		Material(const PxVec4& ambient, const PxVec4& diffuse, const PxVec4& specular, GxF32 shininess);

		static Material Default;
		static Material BlackPlastic; // czarny plastik
		static Material BlackRubber; // czarna guma
		static Material Brass; // mosiadz
		static Material Bronze; // braz
		static Material Chrome; // chrom
		static Material Copper; // miedz
		static Material Emerald; // szmaragd
		static Material Gold; // zloto
		static Material Jade; // jadeit
		static Material Obsidian; // obsydian (szklo wulkaniczne)
		static Material Pearl; // perla
		static Material Pewter; // cyna z olowiem (grafit)
		static Material PolishedBronze; // polerowany braz
		static Material PolishedCopper; // polerowana miedz
		static Material PolishedGold; // polerowane zloto
		static Material PolishedSilver; // polerowane srebro
		static Material Ruby; // rubin
		static Material Silver; // srebro
		static Material Turquoise; // turkus

		bool		isLit; // oswietlony/nieoswietlony
		PxVec4		ambient;
		PxVec4		diffuse;
		PxVec4		specular;
		GxF32		shininess;
		Texture2D*	texture;
		PxVec4		color;
		GxF32		alpha;
	};
}

#endif /* __gx_material_h__ */