#pragma once

#ifndef __sampleboxgame_h__
	#define __sampleboxgame_h__

#include <samplegame.h>

class SampleShapesGame : public SampleGame
{
public:
	SampleShapesGame();

	virtual void initialize();
	virtual void release();
	virtual void input(GxF32 elapsedTime);
	virtual void update(GxF32 elapsedTime);
	virtual void render(GxF32 elapsedTime);

	//mapa wysokosci
	void prepareMaterials();
	void createHeightField(GxF32 heightScale, GxF32 rowScale, GxF32 columnScale);
	bool loadRawHeightField(const char* filename, unsigned char* buffer, int& width, int& height);
	void renderHeightFieldActor(PxRigidActor* rigid, Mesh* graphicsMesh, Material* graphicsMaterial);

	//teddy bear
	void renderTriangleMeshActor(PxRigidActor* rigid, Mesh* graphicsMesh, Material* graphicsMaterial);

	virtual void printHelp();

protected:
	//mapa wysokosci (teren)
	Material groundMaterial;
	Mesh* heightFieldGraphicsMesh;
	PxRigidStatic* heightFieldActor;

	//teddy bear
	Material teddyMaterial;
	Mesh* teddyMesh;
	PxRigidStatic* teddyActor;
};

#endif /* __sampleboxgame_h__ */