#pragma once

#ifndef __gx_contentmanager_h__
	#define __gx_contentmanager_h__

#include "foundation.h"

namespace Gx
{
	class Effect;
	class Texture2D;
	class Model;
	class Mesh;
	class GraphicsDevice;

	class GX_API ContentManager
	{
	public:
		ContentManager(GraphicsDevice* graphicsDevice);

		Effect*		loadEffect(const char* filename);
		Texture2D*	loadTexture(const char* filename);
		Mesh*		loadRawMesh(const char* filename);
		Model*		loadModel(const char* filename, bool normalize = false, bool rebuildNormals = false);

		void setRootDirectory(const std::string& rootDirectory) {
			m_rootDirectory = rootDirectory;
		}

	private:
		std::string m_rootDirectory;
		GraphicsDevice* m_graphicsDevice;
		std::string getFullPath(const std::string& filename) const;
		std::string readDataFromStream(std::ifstream& stream) const;
		std::string getFullPath(const std::string& filename, const std::string& ext);
		std::ifstream openStream(const std::string& path) const;
	};
}

#endif /* __gx_contentmanager_h__ */