#pragma once

#ifndef __gx_gamestepper_h__
	#define __gx_gamestepper_h__

#include "foundation.h"

namespace Gx
{
	class Game;

	/*
	 *	Odpowiada za odpowiednie uruchamianie metod klasy Game.
	 *  Zastosowano symulacje ze staym krokiem czasowym.
	 *  Przy okazji liczy take takie dane jak: FPS oraz UPF.
	 *  UPF - updates per frame - suy do podgldu 'ile razy wykonywane jest update w jednej klatce'
	 */
	class GX_API GameStepper
	{
	public:
		GameStepper(GxF32 timeStep = 1.0f / 60.0f, GxF32 maxAccumulatedTime = 0.05f);

		void advance(Game& game, GxF32 elapsedTime); // w sekundach

		inline void reset() {
			m_timeAccumulator = 0;
		}

		inline GxF32 getFps() const {
			return m_fpsCounter;
		}

		inline GxF32 getUpf() const {
			return m_upfCounter;
		}

	private:
		GxF32			m_fpsTimeAccumulator;
		GxF32			m_fpsCounter;
		GxF32			m_upfCounter; // updates per frame - tymczasowe
		GxU32			m_framesCounter;

		GxF32			m_timeAccumulator;
		const GxF32		m_maxAccumulatedTime;
		const GxF32		m_timeStep;
	};
}

#endif /* __gx_gamestepper_h__ */