#ifndef __gxframework_application_h__
	#define __gxframework_application_h__

#include "shared.h"

namespace Gx
{
	class Game;

	class GXFRAMEWORK_DECLSPEC Application
	{
	public:
		typedef HINSTANCE Instance;

		static bool initialize();
		static void run(Game& game);
		static void quit(int exitCode = 0);

		static Instance getInstance() {
			return Application::m_instance;
		}

		static int getExitCode() {
			return Application::m_exitCode;
		}

	private:
		Application();
		Application(const Application&);
		Application& operator=(const Application&);

		static Instance	m_instance;
		static int		m_exitCode;
	};
}

#endif // ~__gxframework_application_h__
