#ifndef __gxframework_keyboard_h__
	#define __gxframework_keyboard_h__

#include "shared.h"

namespace Gx
{
	namespace Keys
	{
		enum Enum
		{
			D0               = 48,
			D1               = 49,
			D2               = 50,
			D3               = 51,
			D4               = 52,
			D5               = 53,
			D6               = 54,
			D7               = 55,
			D8               = 56,
			D9               = 57,

			A               = 65,
			B               = 66,
			C               = 67,
			D               = 68,
			E               = 69,
			F               = 70,
			G               = 71,
			H               = 72,
			I               = 73,
			J               = 74,
			K               = 75,
			L               = 76,
			M               = 77,
			N               = 78,
			O               = 79,
			P               = 80,
			Q               = 81,
			R               = 82,
			S               = 83,
			T               = 84,
			U               = 85,
			V               = 86,
			W               = 87,
			X               = 88,
			Y               = 89,
			Z               = 90,

			F1              = 112,
			F2              = 113,
			F3              = 114,
			F4              = 115,
			F5              = 116,
			F6              = 117,
			F7              = 118,
			F8              = 119,
			F9              = 120,
			F10             = 121,
			F11             = 122,
			F12             = 123,

			BackSpace       = 8,
			Tab             = 9,
			Enter           = 13,
			CapsLock        = 20,
			Escape          = 27,
			Space           = 32,
			Apps            = 93,
			Semicolon       = 186,
			Add             = 187,
			Comma           = 188,
			Subtract        = 189,
			Period          = 190,
			FwdSlash        = 191,
			Tilde           = 192,
			LBracket        = 219,
			BackSlash       = 220,
			RBracket        = 221,
			Apostrophe      = 222,

			Shift           = 16,
			Ctrl            = 17,
			LWin            = 91,
			RWin            = 92,
			LAlt            = 164,
			RAlt            = 165,

			Insert          = 45,
			Delete          = 46,
			Home            = 36,
			End             = 35,
			PageUp          = 33,
			PageDown        = 34,

			Up              = 38,
			Down            = 40,
			Right           = 39,
			Left            = 37,

			NumLock         = 144,
			NumpadDivide   = 111,
			NumpadMultiply = 106,
			NumpadSubtract = 109,
			NumpadAdd      = 107,
			NumpadDecimal  = 110,
			Numpad0        = 96,
			Numpad1        = 97,
			Numpad2        = 98,
			Numpad3        = 99,
			Numpad4        = 100,
			Numpad5        = 101,
			Numpad6        = 102,
			Numpad7        = 103,
			Numpad8        = 104,
			Numpad9        = 105,
		};
	}

	class GXFRAMEWORK_DECLSPEC Keyboard
	{
	public:
		static Keyboard& getInstance();

		bool isKeyDown(Keys::Enum key) const {
			return (m_currentKeyStates[key] & 0x80) ? true : false;
		}

		bool isKeyUp(Keys::Enum key) const {
			return (m_currentKeyStates[key] & 0x80) ? false : true;
		}

		bool isKeyPressed(Keys::Enum key) const { 
			return ((m_currentKeyStates[key] & 0x80) && !(m_previousKeyStates[key] & 0x80)) ? true : false;
		}

		int getLastChar() const {
			return m_lastChar;
		}

		void handleMessage(UINT msg, WPARAM wparam, LPARAM lparam);

		void update();

	private:
		Keyboard();
		Keyboard(const Keyboard&);
		Keyboard& operator=(const Keyboard&);

		int m_lastChar;
		unsigned char m_keyStates[2][256];
		unsigned char* m_currentKeyStates;
		unsigned char* m_previousKeyStates;
	};
}

#endif // ~__gxframework_keyboard_h__
