#ifndef __shader_h__
	#define __shader_h__

#include <gxframework/gxopengl.h>

namespace ShaderType
{
	enum Enum
	{
		VertexShader = GL_VERTEX_SHADER,
		TessControlShader = GL_TESS_CONTROL_SHADER,
		TessEvaluationShader = GL_TESS_EVALUATION_SHADER,
		GeomentryShader = GL_GEOMETRY_SHADER,
		FragmentShader = GL_FRAGMENT_SHADER
	};
}

class Shader
{
public:
	Shader(ShaderType::Enum shaderType);
	virtual ~Shader();

	bool loadFromSource(const char* source);
	bool loadFromFile(const char* filename);

	bool compile();

	void getLog(char* buffer, const unsigned int size);

	GLuint getHandle() const {
		return m_handle;
	}

private:
	GLuint			 m_handle;
	ShaderType::Enum m_type;
};

#endif // ~__shader_h__
