#include "shaderprogram.h"
#include "shader.h"

ShaderProgram::ShaderProgram() : m_handle(0)
{
}

ShaderProgram::~ShaderProgram()
{
	if ( m_handle )
	{
		::glDeleteProgram(m_handle);
		m_handle = 0;
	}

	TRACE();
}

bool ShaderProgram::create()
{
	TRACE();

	ASSERT(m_handle == 0);
	m_handle = ::glCreateProgram();

	return m_handle != 0;
}

void ShaderProgram::attach( Shader& shader )
{
	TRACE();

	ASSERT(m_handle != 0);
	ASSERT(shader.getHandle() != 0);

	::glAttachShader(m_handle, shader.getHandle());
}

bool ShaderProgram::link()
{
	TRACE();

	ASSERT(m_handle != 0);

	::glLinkProgram(m_handle);

	GLint result = 0;
	::glGetProgramiv(m_handle, GL_LINK_STATUS, &result);

	return result != GL_FALSE;
}

bool ShaderProgram::validate()
{
	TRACE();

	::glValidateProgram(m_handle);

	GLint result = 0;
	::glGetProgramiv(m_handle, GL_VALIDATE_STATUS, &result);

	return result != GL_FALSE;
}

void ShaderProgram::getLog( char * buffer, const int size )
{
	TRACE();

	::glGetProgramInfoLog(m_handle, size, NULL, buffer);
}
