//#pragma once

#define _CRT_SECURE_NO_WARNINGS

/*
Tworzymy projekt Visual C++,Win32 Project (nie zaznaczamy Empty Project, ale czycimy zawarto pliku .cpp)

Zmiany w ustawieniach projektu:
General -> Character set = Use Multi-Byte Character Set
Linker -> Input -> Additional Dependencies: naley doda opengl32.lib (np. na pocztku)
Edycja ikony z Resource Files, OpenGL4.ico
*/

#ifndef OPENGL_H
#define OPENGL_H

#define WIN32_LEAN_AND_MEAN 1
#include <Windows.h>
#define EXIT_FAILURE 1

#include <gl\GL.h>

class COkno
{
protected:
	long szerokoscObszaruUzytkownika;
	long wysokoscObszaruUzytkownika;
	HWND uchwytOkna;

public:
	COkno():uchwytOkna(NULL){};
	bool Init(HINSTANCE uchwytAplikacji,POINT polozenieOkna,POINT rozmiarOkna);
	WPARAM Run();
	LRESULT WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

private:
	bool ZmianaRozdzielczosciEkranu(long szerokosc,long wysokosc,long glebiaKolorow=32) const;

};

//--------------------

class COknoGL : public COkno
{
private:
	HGLRC uchwytRC; //uchwyt kontekstu renderingu
	HDC uchwytDC; //uchwyt prywatnego kontekstu urzadzenia GDI
	bool UstalFormatPikseli(HDC uchwytDC) const;
	bool InitWGL(HWND uchwytOkna,bool uzupelnijTytulOkna = false);
	void UsunWGL();

	//OpenGL 3.3+
	GLuint vao;  //identyfikatory VAO i VBO
	GLuint vbo;
	void InitBuforWerteksow();
	void UsunBuforWerteksow();

	//shadery
	GLuint idProgramuShaderow;
	GLuint PrzygotujShadery(const char* vsNazwaPliku, const char* fsNazwaPliku);

protected:
	void UstawienieSceny();
	void RysujScene();

public:
	COknoGL():COkno(),uchwytRC(NULL),uchwytDC(NULL){};
	LRESULT WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

} okno;

struct CWerteks
{
	float x,y,z; //polozenie
	float r,g,b; //kolor
	
	CWerteks(float x,float y,float z,float r,float g,float b)
		: x(x),y(y),z(z),
		  r(r),g(g),b(b)
	{
	}
};

#endif