#version 330 core

uniform mat4 macierzModelu;
uniform mat4 macierzWidoku;
uniform mat4 macierzRzutowania;

in vec3 pozycja_in;
in vec3 kolor_in;
in vec3 normalna_in;

out vec4 kolor;

//parametry zrodla swiatla
uniform vec4 Ce = vec4(0,0,0,0);
uniform vec4 Ca = vec4(1,1,1,1);
uniform vec4 Cd = vec4(1,1,1,1);
uniform vec4 Cs = vec4(1,1,1,1);

uniform vec3 PozycjaZrodlaSwiatla = vec3(5,2,1);
uniform vec3 PozycjaKamery = vec3(0,0,1);

//parametry materialu
const float wa = 0.1;
const float wd = 1.0;
const float ws = 0.3;
uniform vec4 Wa = vec4(wa,wa,wa,1);
uniform vec4 Wd = vec4(wd,wd,wd,1);
uniform vec4 Ws = vec4(1,0,0,1);
uniform float Ns = 10.0;

vec4 ObliczKolor(vec3 pozycja,vec3 normalna)
{
	vec3 R = pozycja;
	vec3 L = PozycjaZrodlaSwiatla-R;
	float odleglosc = length(L);
	L=normalize(L);
	vec3 N = normalize(normalna);
	float dotLN = clamp(dot(L,N),0.0,1.0);

	vec3 O = 2.0*dotLN*N-L;
	vec3 V = normalize(PozycjaKamery-R);
	float dotOVn = clamp(pow(clamp(dot(O,V),0.0,1.0),Ns),0.0,1.0);

	vec4 kolor = clamp(Ce,0.0,1.0);
	kolor+=clamp(Wa*Ca,0.0,1.0);
	kolor+=clamp(Wd*Cd*dotLN,0.0,1.0);
	kolor+=clamp(Ws*Cs*dotOVn,0.0,1.0);

	return kolor;
}

void main(void)
{
	mat4 macierzMVP = macierzRzutowania * macierzWidoku * macierzModelu;
	gl_Position = macierzMVP*vec4(pozycja_in,1.0);

	mat3 macierzMV = mat3(macierzWidoku*macierzModelu); //do zoptymalizowania
	mat3 macierzN = transpose(macierzMV);
	vec3 pozycja = macierzMV*pozycja_in;
	vec3 normalna = normalna_in*macierzN; //kolejnosc!!!!!!!
	
	//kolor.rgb = kolor_in;	
	//kolor.a = 1.0;
	kolor = ObliczKolor(pozycja,normalna); //Phong
}