#version 330 core

in vec4 kolor;
in vec3 pozycja;
in vec3 normalna;

out vec4 kolor_out;

//parametry zrodla swiatla
uniform vec4 Ce = vec4(0,0,0,0);
uniform vec4 Ca = vec4(1,1,1,1);
uniform vec4 Cd = vec4(1,1,1,1);
uniform vec4 Cs = vec4(1,1,1,1);

uniform vec3 PozycjaZrodlaSwiatla = vec3(5,2,1);
uniform vec3 PozycjaKamery = vec3(0,0,1);

//parametry materialu
const float wa = 0.1;
const float wd = 1.0;
const float ws = 0.3;
uniform vec4 Wa = vec4(wa,wa,wa,1);
uniform vec4 Wd = vec4(wd,wd,wd,1);
uniform vec4 Ws = vec4(ws,ws,ws,1);
uniform float Ns = 10.0;

uniform bool KopiujKolorWerteksu = false;

//teksturowanie
uniform bool Teksturowanie = true;
uniform sampler2D samplerTekstury;
in vec2 wspTeksturowania;

uniform sampler2D samplerDodatkowejTekstury;

vec4 ObliczKolor(vec3 pozycja,vec3 normalna)
{
	vec3 R = pozycja;
	vec3 L = PozycjaZrodlaSwiatla-R;
	float odleglosc = length(L);
	L=normalize(L);
	vec3 N = normalize(normalna);
	float dotLN = clamp(dot(L,N),0.0,1.0);

	vec3 O = 2.0*dotLN*N-L;
	vec3 V = normalize(PozycjaKamery-R);
	float dotOVn = clamp(pow(clamp(dot(O,V),0.0,1.0),Ns),0.0,1.0);

	vec4 _Wa = Wa;
	vec4 _Wd = Wd;

	if(KopiujKolorWerteksu)
	{
		_Wa = kolor;
		_Wd = kolor;
	}
	if(Teksturowanie)
	{
		vec4 teksel1 = texture2D(samplerTekstury,wspTeksturowania);
		vec4 teksel2 = texture2D(samplerDodatkowejTekstury,wspTeksturowania);

		//_Wd.rgb = (0.4*teksel1+0.6*teksel2).rgb;
		//_Wd.rgb = (teksel1*teksel2).rgb;
		_Wd.rgb = ((1-wspTeksturowania.x)*teksel1+wspTeksturowania.x*teksel2).rgb;
		_Wd.a = 1;
		_Wa = _Wd;
	}

	vec4 kolor = clamp(Ce,0.0,1.0);
	kolor+=clamp(_Wa*Ca,0.0,1.0);
	kolor+=clamp(_Wd*Cd*dotLN,0.0,1.0);
	kolor+=clamp(Ws*Cs*dotOVn,0.0,1.0);

	return kolor;
}

void main(void)
{	
	//gl_FragColor = gl_Color; //wersja 110
	//kolor_out = kolor;
	
	kolor_out = ObliczKolor(pozycja,normalna);
	
	//weryfikacja wsp. teksturowania
	//kolor_out.rg = wspTeksturowania.ts; 
	//kolor_out.ba = vec2(0,1);
}