#ifndef WERTEKS_H
#define WERTEKS_H

struct CWerteks
{
	float x, y, z; //wsprzdne poozenia
	float nx, ny, nz; //wsprzdne normalnej
	float s, t; //wsprzdne teksturowania
	float r, g, b, a; //skadowe koloru

	static const int liczbaWsprzdnychPooenia = 3;
	static const int rozmiarWektoraPooenia = liczbaWsprzdnychPooenia * sizeof(float);
	static const int liczbaWsprzdnychNormalnej = 3;
	static const int rozmiarNormalnej = liczbaWsprzdnychNormalnej * sizeof(float);
	static const int liczbaWsprzdnychTeksturowania = 2;
	static const int rozmiarWsprzdnychTeksturowania = liczbaWsprzdnychTeksturowania * sizeof(float);
	static const int liczbaSkadowychKoloru = 4;
	static const int rozmiarWektoraKoloru = liczbaSkadowychKoloru * sizeof(float);
	static const int rozmiarWerteksu = rozmiarWektoraPooenia + rozmiarNormalnej + rozmiarWsprzdnychTeksturowania + rozmiarWektoraKoloru;

	CWerteks()
		:x(0.0f), y(0.0f), z(0.0f),
		nx(0.0f), ny(0.0f), nz(0.0f),
		s(0.0f), t(0.0f),
		r(0.0f), g(0.0f), b(0.0f), a(1.0f)		
	{
	}

	CWerteks(
		float x, float y, float z, 
		float nx, float ny, float nz,
		float s, float t,
		float r = 1.0f, float g = 1.0f, float b = 1.0f, float a = 1.0f)
		: x(x), y(y), z(z),
		nx(nx), ny(ny), nz(nz),
		s(s), t(t),
		r(r), g(g), b(b), a(a)
	{
	}
};

#endif