#ifndef AKTOR_H
#define AKTOR_H

#include "MacierzGL.h"
#include "Werteks.h"

class Aktor
{
protected:
	unsigned int vao, vbo;
	unsigned int liczbaWerteksw;

private:
	void InicjujBuforWerteksw();
	void UsuBuforWerteksw();

protected:	
	virtual unsigned int TwrzTablicWerteksw(CWerteks*& werteksy) = 0; //obowizki: zapenienie tablicy werteksw, zwrcenie liczby werteksw

public:	
	Macierz4 Macierzwiata;
	virtual void Inicjuj(GLuint atrybutPooenie /*= 0*/, GLuint atrybutNormalna /*= 1*/, GLuint atrybutKolor /*= 3*/); //moe by wywoywane w konstruktorach klas potomnych, ale nie klasy bazowej
	virtual void Rysuj();
	
	Aktor();	
	virtual ~Aktor();	
};

//typedef Aktor* PAktor;

//--------------------------------------------

class AktorZBuforemIndeksw : public Aktor
{
protected:
	unsigned int liczbaIndeksw;
	unsigned int vbo_indeksy;

private:
	void InicjujBuforIndeksw();
	void UsuBuforIndeksw();

protected:
	virtual unsigned int TwrzTablicIndeksw(GLuint*& indeksy) = 0;

public:
	virtual void Inicjuj(GLuint atrybutPooenie /*= 0*/, GLuint atrybutNormalna /*= 1*/, GLuint atrybutKolor /*= 3*/);
	virtual void Rysuj();

	AktorZBuforemIndeksw();
	virtual ~AktorZBuforemIndeksw();
};

//--------------------------------------------

/*
class Kwadrat : public Aktor
{
private:
	float dugoKrawdzi;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	Kwadrat(GLuint atrybutPooenie, GLuint atrybutKolor, float dugoKrawdzi = 2.0f);
};

class Trjkt : public Aktor
{
private:
	float dugoPodstawy, wysoko;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	Trjkt(GLuint atrybutPooenie, GLuint atrybutKolor, float dugoPodstawy = 2.0f, float wysoko = 2.0f);
};

class KwadratZBuforemIndeksw : public AktorZBuforemIndeksw
{
private:
	float dugoKrawdzi;	
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);
	unsigned int TwrzTablicIndeksw(GLubyte*& indeksy);

public:
	KwadratZBuforemIndeksw(GLuint atrybutPooenie, GLuint atrybutKolory, float dugoKrawdzi = 2.0f);
};
*/

//--------------------------------------------

class Prostopadocian : public Aktor
{
private:	
	float dugoKrawdziX, dugoKrawdziY, dugoKrawdziZ;
	bool koloruj;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

	int pierwszeWerteksyPodcigw[6];
	int liczbyWertekswWPodcigach[6];

public:
	void Rysuj();

	Prostopadocian(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoKrawdziX, float dugoKrawdziY, float dugoKrawdziZ, bool koloruj);

	static Prostopadocian* StwrzSzecian(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoKrawdzi, bool koloruj)
	{
		return new Prostopadocian(atrybutPooenie, atrybutNormalna, atrybutKolor, dugoKrawdzi, dugoKrawdzi, dugoKrawdzi, koloruj);
	}
};

#endif
