#version 330 core

//parametry zrodla swiatla
uniform vec4 Ca = vec4(1,1,1,1);
uniform vec4 Cd = vec4(1,1,1,1);
uniform vec4 Cs = vec4(1,1,1,1);
uniform vec3 PolozenieZrodlaSwiatla = vec3(5,2,1);
uniform vec3 PolozenieKamery = vec3(0, 0, 1);

//parametry materialow
const float wa = 0.1;
const float wd = 0.9;
uniform vec4 Wa = vec4(wa, wa, wa, 1);
uniform vec4 Wd = vec4(wd, wd, wd, 1);
uniform vec4 Ws = vec4(1, 1, 0, 1);
uniform float WNs = 10.0;

uniform bool OslabienieSwiatla = true;
uniform vec3 WspolczynnikiOslabieniaOswietlenia = vec3(0,0.5,0);

float Oslabienie(float odleglosc)
{
    if(!OslabienieSwiatla) return 1;
	else return 1.0/(WspolczynnikiOslabieniaOswietlenia[0] + 
	                 WspolczynnikiOslabieniaOswietlenia[1]*odleglosc + 
					 WspolczynnikiOslabieniaOswietlenia[2]*odleglosc*odleglosc);
}

vec4 ObliczKolorPhong(vec3 polozenie, vec3 normalna, vec4 kolor)
{
	vec3 R = polozenie;
	vec3 L = PolozenieZrodlaSwiatla - R;
	float odleglosc = length(L);
	L = normalize(L);
	vec3 N = normalize(normalna);
	float dotLN = dot(L, N);

	vec3 O = -L + 2.0*dotLN*N;
	vec3 V = normalize(PolozenieKamery - R);
	float dotOVn = pow(max(dot(O,V),0.0),WNs);

	vec4 _kolor = Ca * Wa * kolor; //ambient
	_kolor += Cd * Wd * kolor * dotLN * Oslabienie(odleglosc); //diffuse
	_kolor += Cs * Ws * kolor * dotOVn; //specular
	return _kolor;
}

in vec4 polozenie;
in vec4 kolor;
in vec3 polozenie_scena;
in vec3 normalna_scena;

out vec4 kolor_out;

float DyskretyzujWartosc(float wartosc)
{
	if(wartosc>=0 && wartosc<=0.25) return 0.1;
	if(wartosc>0.25 && wartosc<=0.5) return 0.4;
	if(wartosc>0.5 && wartosc<=0.75) return 0.7;
	return 1;
}

vec4 DyskretyzujKolor(vec4 kolor)
{
	kolor.r = DyskretyzujWartosc(kolor.r);
	kolor.g = DyskretyzujWartosc(kolor.g);
	kolor.b = DyskretyzujWartosc(kolor.b);
	return kolor;
}

void main(void)
{
	//kolor_out = kolor;

	//if(polozenie.y < 0.1*sin(100*polozenie.x)) kolor_out = vec4(1,1,1,1);
	//else kolor_out = vec4(1,0,0,1);

	kolor_out = ObliczKolorPhong(polozenie_scena, normalna_scena, kolor);
	//kolor_out = DyskretyzujKolor(kolor_out);
}