#version 330 core

in vec4 polozenie;
in vec4 kolor;
in vec2 wspTekstur;
in vec3 polozenie_scena;
in vec3 normalna_scena;

//parametry zrodla swiatla
uniform vec4 Ca = vec4(1,1,1,1);
uniform vec4 Cd = vec4(1,1,1,1);
uniform vec4 Cs = vec4(1,1,1,1);
uniform vec3 PolozenieZrodlaSwiatla = vec3(5,2,1);
uniform vec3 PolozenieKamery = vec3(0,0,1);

//parametry materialu
const float wa = 0.1;
const float wd = 1.0;
//const float ws = 0.3;
uniform vec4 Wa = vec4(wa,wa,wa,1);
uniform vec4 Wd = vec4(wd,wd,wd,1);
uniform vec4 Ws = vec4(0,1,0,1);
uniform float WNs = 100.0;

uniform bool OslabienieOswietlenia = false;
uniform vec3 WspolczynnikiOslabieniaOswietlenia = vec3(1,0,0);

float Oslabienie(float odleglosc)
{
    if(!OslabienieOswietlenia) return 1;
    else return 1.0/(WspolczynnikiOslabieniaOswietlenia[0]+
                     WspolczynnikiOslabieniaOswietlenia[1]*odleglosc+
                     WspolczynnikiOslabieniaOswietlenia[2]*odleglosc*odleglosc);
}

uniform bool Teksturowanie = true;
uniform sampler2D ProbnikTekstury;

vec4 ObliczKolorPhong(vec3 polozenie,vec3 normalna,vec2 wspTekstur,vec4 kolor)
{
	vec3 R = polozenie;
	vec3 L = PolozenieZrodlaSwiatla-R;
	float odleglosc = length(L);
	float oslabienie = Oslabienie(odleglosc);
	L=normalize(L);
	vec3 N = normalize(normalna);
	float dotLN = dot(L,N);

	vec3 O = 2.0*dotLN*N-L;	//vec3 O = reflect(-L,N);
	vec3 V = normalize(PolozenieKamery-R);
	float dotOVn = pow(max(dot(O,V),0.0),WNs);

	dotLN = max(dotLN,0.0);

	vec4 teksel = vec4(1.0f, 1.0f, 1.0f, 1.0f);
	if(Teksturowanie) teksel = texture2D(ProbnikTekstury, wspTekstur);
	teksel.a = 1;

	vec4 _kolor = Wa*Ca*kolor*teksel;
	_kolor+= oslabienie*Wd*Cd*kolor*teksel*dotLN;
	_kolor+= oslabienie*Ws*Cs*dotOVn;
	//_kolor = teksel;
	//_kolor = vec4(wspTekstur.t,wspTekstur.s,0,1);
	
	return _kolor;
}

uniform bool CelShading = false;

float DyskretyzujWartosc(float wartosc)
{
	if(wartosc>=0 && wartosc <=0.25) return 0.1;
	if(wartosc>0.25 && wartosc <=0.5) return 0.4;
	if(wartosc>0.5 && wartosc <=0.75) return 0.7;
	return 1;
}

vec4 DyskretyzujKolor(vec4 kolor) //cel-shading
{
	kolor.r = DyskretyzujWartosc(kolor.r);
	kolor.g = DyskretyzujWartosc(kolor.g);
	kolor.b = DyskretyzujWartosc(kolor.b);
	return kolor;
}

out vec4 kolor_out;

void main(void)
{
	kolor_out = ObliczKolorPhong(polozenie_scena,normalna_scena,wspTekstur,kolor);
	if(CelShading) kolor_out = DyskretyzujKolor(kolor_out);
}