float4x4 World : WORLD;

//parametry rda wiata
float4x4 ZrodloSwiatla_ViewProjection;
float3 PozycjaZrodlaSwiatla : LIGHTPOSITION;

//parametry kamery
float4x4 Kamera_ViewProjection : VIEWPROJECTION;
float3 PozycjaKamery : CAMERAPOSITION;

//Maksymalna wartosc glebi dla renderingu z perspektywy swiatla
float MaksymalnaOdlegloscZrodlaSwiatla;

struct VS_MapaGlebi_Input
{
	float4 Pozycja : POSITION;
};

struct VS_MapaGlebi_Output
{
	float4 Pozycja : POSITION;
	float Glebokosc : TEXCOORD1;
};

VS_MapaGlebi_Output VS_MapaGlebi(VS_MapaGlebi_Input input)
{
	VS_MapaGlebi_Output output;
	float4x4 wvp = mul(World,ZrodloSwiatla_ViewProjection);
	output.Pozycja=mul(input.Pozycja, wvp);
	//zapisujemy wartosc glebi ([0-1])
	output.Glebokosc=output.Pozycja.z/MaksymalnaOdlegloscZrodlaSwiatla;
	return output;
}

float4 PS_MapaGlebi(VS_MapaGlebi_Output input) : COLOR0
{
	return float4(1,1,1,0)*input.Glebokosc+float4(0,0,0,1);
}

technique Technika_MapaGlebi
{
	pass Przebieg
	{
		CullMode = NONE;
		VertexShader = compile vs_2_0 VS_MapaGlebi();
		PixelShader = compile ps_2_0 PS_MapaGlebi();
	}
}
