﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Klasa
{
    public class Ulamek
    {
        private int licznik = 0;
        private int mianownik = 1;

        public int Licznik
        {
            get
            {
                return licznik;
            }
            set
            {
                licznik = value;
            }
        }

        public int Mianownik
        {
            get
            {
                return mianownik;
            }
            set
            {
                if (value != 0) mianownik = value;
                else throw new Exception("Nie dziel przez zero!");
            }
        }

        public Ulamek(int licznik, int mianownik = 1)
        {
            Licznik = licznik;
            Mianownik = mianownik;
        }

        public override string ToString()
        {
            //return base.ToString();
            return Licznik.ToString() + "/" + Mianownik.ToString();
        }

        public double ToDouble()
        {
            return Licznik / (double)Mianownik;
        }

        public static Ulamek operator +(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public static Ulamek operator -(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public static Ulamek operator *(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Licznik, u1.Mianownik * u2.Mianownik);
        }

        public static Ulamek operator /(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Mianownik, u1.Mianownik * u2.Licznik);
        }

        public void Uprosc()
        {
            int mniejsza = Math.Min(Math.Abs(Licznik), Math.Abs(Mianownik));
            for (int i = mniejsza; i > 0; i--)
            {
                if ((Licznik % i == 0) && (Mianownik % i == 0))
                {
                    Licznik /= i;
                    Mianownik /= i;
                }

                //znaki
                if (Licznik * Mianownik < 0)
                {
                    Licznik = -Math.Abs(Licznik);
                    Mianownik = Math.Abs(Mianownik);
                }
                else
                {
                    Licznik = Math.Abs(Licznik);
                    Mianownik = Math.Abs(Mianownik);
                }
            }
        }

        zrobić statyczną wersję uprość
    }
}