﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.IO;
using System.Xml.Linq;

namespace KsiegaGosci
{
    public struct Wpis
    {
        public string nazwaUżytkownika;
        public string treścWpisu;
        public DateTime data;
        public string adresIP;

        public Wpis(string _nazwaUżytkownika, string _treścWpisu, DateTime _data, string _adresIP)
        {
            nazwaUżytkownika = _nazwaUżytkownika;
            treścWpisu = _treścWpisu;
            data = _data;
            adresIP = _adresIP;
        }
    }

    public class Wpisy
    {
        private List<Wpis> wpisy = new List<Wpis>();
        private string nazwaPliku="d:\\Wpisy.xml";

        public void Dodaj(Wpis wpis)
        {
            wpisy.Add(wpis);
            ZapiszDoPlikuXml();
        }

        public int Ilość
        {
            get
            {
                return wpisy.Count;
            }
        }

        public Wpis PobierzWpis(int i)
        {
            return wpisy[i];
        }

        public bool ZapiszDoPlikuXml()
        {
            try
            {
                if (File.Exists(nazwaPliku)) File.Copy(nazwaPliku, nazwaPliku + ".bak", true);

                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisuPliku", DateTime.Now.ToString())
                    )
                );

                for(int i=0;i<wpisy.Count;++i)
                {
                    Wpis wpis = wpisy[i];

                    xml.Root.Add(
                        new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.nazwaUżytkownika),
                            new XElement("TreśćWpisu", wpis.treścWpisu),
                            new XElement("Data", wpis.data),
                            new XElement("AdresIP", wpis.adresIP)
                        )
                    );
                }

                xml.Save(nazwaPliku);

                return true;
            }
            catch (Exception exc)
            {
                return false;
            }
        }

        public bool CzytajZPlikuXml()
        {
            try
            {
                XDocument xml = XDocument.Load(nazwaPliku);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpis in xml.Descendants("Wpis")
                    select new Wpis(
                        wpis.Element("NazwaUżytkownika").Value,
                        wpis.Element("TreśćWpisu").Value,
                        DateTime.Parse(wpis.Element("Data").Value),
                        wpis.Element("AdresIP").Value
                        );

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);

                return true;
            }
            catch (Exception exc)
            {
                return false;
            }
        }
    }
}