﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using KsiegaGosci.ReferencjaDoUslugiWpisy;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WyświetlWpisy();

            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazweUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text != "" && TextBox2.Text != "")
            {
                Wpis wpis = new Wpis()
                {
                    NazwaUżytkownika = TextBox1.Text.Trim(),
                    Treść = TextBox2.Text.Trim(),
                    Data = DateTime.Now,
                    AdresIP = Request.UserHostAddress
                };
                using (UslugaWpisyClient klientUslugi = new UslugaWpisyClient())
                {
                    klientUslugi.DodajWpis(wpis);
                }

                WyświetlWpisy();
                TextBox2.Text = "";                
                ZapamietajNazweUżytkownika(TextBox1.Text);
            }
        }

        bool odwróćKolejność = true;

        string PrzekształćWpisDoHtml(Wpis wpis)
        {
            return "<B>" + wpis.NazwaUżytkownika + "</B><BR>" +
                    wpis.Treść + "<BR>" +
                    "<I>Dodano: " + wpis.Data + ", " + wpis.AdresIP + "</I><P>";
        }

        private void WyświetlWpisy()
        {
            Wpis[] wpisy;
            using (UslugaWpisyClient klientUslugi = new UslugaWpisyClient())
            {
                wpisy = klientUslugi.PobierzWszystkieWpisy();
            }

            string trescWpisow = "";
            if (odwróćKolejność) for (int i = wpisy.Count() - 1; i >= 0; --i)
                    trescWpisow += PrzekształćWpisDoHtml(wpisy[i]);
            else for(int i=0; i<wpisy.Count(); ++i)
                    trescWpisow += PrzekształćWpisDoHtml(wpisy[i]);
            Label1.Text = trescWpisow;

            /*
            Label1.Text = "";
            string tytuł = "Wpisy:<P>";
            for (int i = 0; i < wpisy.Ilość; ++i)
            {
                Wpis wpis=wpisy.PobierzWpis(i);
                string sWpis =
                    "<B>" + wpis.nazwaUżytkownika + "</B><BR>" +
                    wpis.treścWpisu + "<BR>" +
                    "<I>Dodano: " + wpis.data + ", " + wpis.adresIP + "</I><P>";
                if (odwróćKolejność) Label1.Text = sWpis + Label1.Text;
                else Label1.Text += sWpis;
            }
            Label1.Text = tytuł + Label1.Text;            
            */
        }

        void ZapamietajNazweUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("nazwaUżytkownika", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazweUżytkownika()
        {
            HttpCookie ciasteczko=Request.Cookies["nazwaUżytkownika"];
            if (ciasteczko != null) return ciasteczko.Value;
            else return null;
        }
        
    } //klasa
} //przestrzeni nazw