﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.IO;
using System.Xml.Linq;

namespace Wpisy_BibliotekaUslug
{
    public class Wpisy
    {
        private List<Wpis> wpisy = new List<Wpis>();
        private string nazwaPliku="d:\\Wpisy.xml";

        public Wpisy()
        {
            CzytajZPlikuXml();
        }

        public void Dodaj(Wpis wpis)
        {
            wpisy.Add(wpis);
            ZapiszDoPlikuXml();            
        }

        public int Ilość
        {
            get
            {
                return wpisy.Count;
            }
        }

        public Wpis PobierzWpis(int i)
        {
            return wpisy[i];
        }

        public Wpis[] DoTablicy()
        {
            return wpisy.ToArray<Wpis>();
        }

        public bool ZapiszDoPlikuXml()
        {
            try
            {
                if (File.Exists(nazwaPliku)) File.Copy(nazwaPliku, nazwaPliku + ".bak", true);

                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisuPliku", DateTime.Now.ToString())
                    )
                );

                for(int i=0;i<wpisy.Count;++i)
                {
                    Wpis wpis = wpisy[i];

                    xml.Root.Add(
                        new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                            new XElement("TreśćWpisu", wpis.Treść),
                            new XElement("Data", wpis.Data),
                            new XElement("AdresIP", wpis.AdresIP)
                        )
                    );
                }

                DopiszDoPlikuLog("Dane zostaną zapisane do pliku: " + nazwaPliku);

                xml.Save(nazwaPliku);

                DopiszDoPlikuLog("Dane zostały zapisane do pliku: " + nazwaPliku);

                return true;
            }
            catch (Exception exc)
            {
                DopiszDoPlikuLog("Błąd zapisu do pliku XML: " + nazwaPliku + " (" + exc.Message + ")");
                return false;
            }
        }

        public bool CzytajZPlikuXml()
        {
            try
            {
                DopiszDoPlikuLog("Dane mają zostać odczytane z pliku: " + nazwaPliku);

                XDocument xml = XDocument.Load(nazwaPliku);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpis in xml.Descendants("Wpis")
                    select new Wpis(
                        wpis.Element("NazwaUżytkownika").Value,
                        wpis.Element("TreśćWpisu").Value,
                        DateTime.Parse(wpis.Element("Data").Value),
                        wpis.Element("AdresIP").Value
                        );

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);

                DopiszDoPlikuLog("Dane zostały odczytane z pliku: " + nazwaPliku);

                return true;
            }
            catch (Exception exc)
            {
                DopiszDoPlikuLog("Błąd odczytu z pliku XML: " + nazwaPliku + " (" + exc.Message + ")");
                return false;
            }
        }

        public static bool DopiszDoPlikuLog(string wpis)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter("d:\\Zdarzenia.log", true))
                {
                    sw.WriteLine(DateTime.Now.ToString() + " - " + wpis.Replace("\r", ""));
                    sw.Close();
                    return true;
                }
            }
            catch (Exception exc)
            {
                return false;
            }
        }
    }
}