﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using System.IO;

namespace KsiegaGosci
{
    public class Global : System.Web.HttpApplication
    {
        public static string nazwaZmiennej_Wpisy = "wpisy";

        protected void Application_Start(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Aplikacja uruchamia się");
            Global.DopiszDoPlikuLog("Aplikacja została uruchamiona");
        }

        protected void Session_Start(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Uruchomienie sesji");
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Autentykacja");
        }

        protected void Application_Error(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Błąd aplikacji !!!!!!!!!");
        }

        protected void Session_End(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Koniec sesji");
        }

        protected void Application_End(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Zamknięcie aplikacji");
        }

        public static bool DopiszDoPlikuLog(string wpis)
        {
            try
            {                
                using (StreamWriter sw = new StreamWriter("d:\\Zdarzenia.log", true))
                {
                    sw.WriteLine(DateTime.Now.ToString() + " - " + wpis.Replace("\r", ""));                    
                    sw.Close();
                    return true;
                }
            }
            catch (Exception exc)
            {
                return false;
            }
        }

    } //koniec: class Global
} //koniec: namespace KsiegaGosci