﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        List<string> wpisy;

        protected void Page_Load(object sender, EventArgs e)
        {
            wpisy = (List<string>)Application["Wpisy"];
            WyświetlWpisy();
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
                else TextBox1.Text = "Wpisz swoje imię...";
            }
        }

        void WyświetlWpisy()
        {
            Label1.Text = "";
            for (int i = 0; i < wpisy.Count; ++i) Label1.Text += wpisy[i];
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            string wpis = 
                "<B>" + TextBox1.Text + "</B><BR>"+ 
                TextBox2.Text.Replace("\n","<BR>") + "<BR>Dodano " + 
                "<I>" + DateTime.Now.ToString() + 
                " z komputera " + Request.UserHostAddress + "</I><P>";

            wpisy.Add(wpis);
            ZapamiętajNazwęUżytkownika(TextBox1.Text);
            Global.DopiszDoPlikuTxt(wpis);

            WyświetlWpisy();
        }

        void ZapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("nazwaUżytkownika", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazwęUżytkownika()
        {
            HttpCookie ciasteczko = Request.Cookies["nazwaUżytkownika"];
            if (ciasteczko != null) return ciasteczko.Value;
            else return null;
        }

    } //klasa Default
} //namespace KsiegaGosci