﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Xml.Linq;

namespace KsiegaGosci
{
    public class Wpis
    {
        public string NazwaUżytkownika;
        public string Treść;
        public DateTime Data;
        public string AdresIP;

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
        {
            this.NazwaUżytkownika = nazwaUżytkownika;
            this.Treść = treść;
            this.Data = data;
            this.AdresIP = adresIP;
        }
    }

    public class Model
    {
        private List<Wpis> wpisy = new List<Wpis>();

        public void Dodaj(Wpis nowyWpis)
        {
            wpisy.Add(nowyWpis);
            ZapiszDoPlikuXml();
        }

        public int Liczba
        {
            get
            {
                return wpisy.Count;
            }
            /*
            set
            {
            }
            */
        }

        public Wpis PobierzWpis(int i)
        {
            return wpisy[i];
        }

        //indekser - nie będzie na kolokwium
        public Wpis this[int i]
        {
            get
            {
                return PobierzWpis(i);
            }
        }

        private const string nazwaPlikuXml = "D:\\jmatulewski\\KsiegaGosci.xml";

        private bool ZapiszDoPlikuXml()
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisu", DateTime.Now.ToString())
                        )
                    );

                for (int i = 0; i < wpisy.Count; ++i)
                {
                    Wpis wpis = wpisy[i];
                    xml.Root.Add(new XElement("Wpis",
                        new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                        new XElement("Treść", wpis.Treść),
                        new XElement("Data", wpis.Data),
                        new XElement("AdresIP", wpis.AdresIP)
                            )
                        );
                }

                xml.Save(nazwaPlikuXml);
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }

        private bool CzytajPlikXml()
        {
            try
            {
                XDocument xml = XDocument.Load(nazwaPlikuXml);

                //zapytanie LINQ - nie będzie na kolokwium
                var odczytaneWpisy = from element_wpis in xml.Descendants("Wpis")
                                     select
                                        new Wpis(
                                            element_wpis.Element("NazwaUżytkownika").Value,
                                            element_wpis.Element("Treść").Value,
                                            DateTime.Parse(element_wpis.Element("Data").Value),
                                            element_wpis.Element("AdresIP").Value
                                            );

                wpisy.Clear();
                wpisy = odczytaneWpisy.ToList();                

                return true;
            }
            catch (Exception exc)
            {
                return false;
            }
        }

        public Model()
        {
            CzytajPlikXml();
        }
    }
}