﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Xml.Linq;

namespace MojaPierwszaAplikacjaAspNet.Models
{
    public class Wpisy
    {
        List<Wpis> wpisy = new List<Wpis>();
        private string nazwaPlikuXml = @"d:\wpisy.xml";
        public bool ZapiszDoPlikuPoKażdymDodaniuWpisu = true;

        public Wpisy(string nazwaPlikXml = null)
        {
            if(nazwaPlikXml!=null) this.nazwaPlikuXml = nazwaPlikXml;
            czytajZPlikuXml(nazwaPlikXml);
        }

        public void Dodaj(Wpis nowyWpis)
        {
            wpisy.Add(nowyWpis);
            if (ZapiszDoPlikuPoKażdymDodaniuWpisu) ZapiszDoPlikuXml();
        }

        public int Liczba
        {
            get
            {
                return wpisy.Count;
            }
        }

        public Wpis this[int i]
        {
            get
            {
                return wpisy[i];
            }
        }

        public bool ZapiszDoPlikuXml(string nazwaPlikuXml = null)
        {
            if (nazwaPlikuXml == null) nazwaPlikuXml = this.nazwaPlikuXml;
            if (string.IsNullOrWhiteSpace(nazwaPlikuXml)) return false;

            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Plik utworzony przez KsięgaGości: " + DateTime.Now.ToString()),
                    new XElement("Wpisy",
                        //LINQ
                        from wpis in wpisy  
                        select new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                            new XElement("Treść", wpis.Treść),
                            new XElement("Data", wpis.Data),
                            new XElement("AdresIP", wpis.AdresIP)
                        )
                    )
                );
                xml.Save(nazwaPlikuXml);
                return true;
            }
            catch(Exception exc)
            {
                Global.Log("Błąd podczas zapisywania pliku XML: " + exc.Message);
                return false;
            }
        }

        private bool czytajZPlikuXml(string nazwaPliku = null)
        {
            if (nazwaPliku == null) nazwaPliku = this.nazwaPlikuXml;
            if (string.IsNullOrWhiteSpace(nazwaPliku)) return false;

            try
            {
                XDocument xml = XDocument.Load(nazwaPliku);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpisXml in xml.Descendants("Wpis")
                    select new Wpis(
                        wpisXml.Element("NazwaUżytkownika").Value,
                        wpisXml.Element("Treść").Value,
                        DateTime.Parse(wpisXml.Element("Data").Value),
                        wpisXml.Element("AdresIP").Value);

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);
                return true;
            }
            catch(Exception exc)
            {
                Global.Log("Błąd podczas odczytu pliku XML: " + exc.Message);
                return false;
            }
        }
    }
}