﻿using System;

namespace UMK.WzorceStrukturalne
{
    abstract class Znak
    {
        //stan wewnętrzny
        protected char litera;
        //protected ConsoleColor kolor;

        public Znak(char litera/*, ConsoleColor kolor*/)
        {
            this.litera = litera;
            //this.kolor = kolor;
        }

        public void Wyświetl(ConsoleColor kolor)
        {
            ConsoleColor oryginalnyKolor = Console.ForegroundColor;
            Console.ForegroundColor = kolor;
            Console.Write(litera);
            Console.ForegroundColor = oryginalnyKolor;
        }
    }

    class ZnakA : Znak
    {
        public ZnakA()
            : base('A')
        { }
    }

    class ZnakB : Znak
    {
        public ZnakB()
            : base('B')
        { }
    }

    class ZnakC : Znak
    {
        public ZnakC()
            : base('C')
        { }
    }

    class ZnakD : Znak
    {
        public ZnakD()
            : base('D')
        { }
    }

    class ZnakJ : Znak
    {
        public ZnakJ()
            : base('J')
        { }
    }

    class ZnakU : Znak
    {
        public ZnakU()
            : base('U')
        { }
    }

    class ZnakNierozpoznany : Znak
    {
        public ZnakNierozpoznany()
            : base('?')
        { }
    }

    sealed class FabrykaZnaków
    {
        #region Singleton
        public static FabrykaZnaków Instancja { get; private set; } = new FabrykaZnaków();

        private FabrykaZnaków() { }
        #endregion

        private Dictionary<char, Znak> znaki = new Dictionary<char, Znak>();

        public Znak PobierzZnak(char litera)
        {
            Znak znak = null;
            if(znaki.ContainsKey(litera)) znak = znaki[litera];
            else
            {
                switch(litera)
                {
                    case 'A':
                        znak = new ZnakA();
                        break;
                    case 'B':
                        znak = new ZnakB();
                        break;
                    case 'C':
                        znak = new ZnakC();
                        break;
                    case 'D':
                        znak = new ZnakD();
                        break;
                    case 'J':
                        znak = new ZnakJ();
                        break;
                    case 'U':
                        znak = new ZnakU();
                        break;
                    default:
                        znak = new ZnakNierozpoznany();
                        break;
                }
                znaki.Add(litera, znak);
            }
            return znak;
        }
    }
}