﻿namespace Kompozyt
{
    public interface IOdwiedzający
    {
        void Odwiedź(IPracownik pracownik);
    }

    public interface IPracownik
    {
        //void WyświetlInformacje(int głębokość);
        void PrzyjmijWizytę(IOdwiedzający odwiedzający, int głębokość);
    }

    public class Pracownik : IPracownik
    {
        private string imię, nazwisko, stanowisko;
        protected internal bool odwiedzony = false;

        public Pracownik(string imię, string nazwisko, string stanowisko)
        {
            this.imię = imię;
            this.nazwisko = nazwisko;
            this.stanowisko = stanowisko;
        }

        public override string ToString()
        {
            return imię + " " + nazwisko + " (" + stanowisko + ")";
        }

        /*
        public virtual void WyświetlInformacje(int głębokość)
        {
            zróbWcięcie(głębokość);
            Console.WriteLine(ToString());
            odwiedzony = true;
        }
        */
        public virtual void PrzyjmijWizytę(IOdwiedzający odwiedzający, int głębokość)
        {
            //zróbWcięcie(głębokość);
            //Console.WriteLine(ToString());
            odwiedzający.Odwiedź(this);
            odwiedzony = true;
        }

        protected void zróbWcięcie(int głębokość)
        {
            for (int i = 0; i < głębokość; i++) Console.Write(' ');
        }

        public virtual void Resetuj()
        {
            odwiedzony = false;
        }
    }

    public class Kierownik : Pracownik
    {
        private List<IPracownik> podwładni = new List<IPracownik>();

        public Kierownik(string imię, string nazwisko, string stanowisko, List<IPracownik>? podwładni = null) :
            base(imię, nazwisko, stanowisko)
        {
            if (podwładni != null && podwładni.Count > 0) this.podwładni.AddRange(podwładni);
        }

        public void DodajPodwładnego(IPracownik podwładny)
        {
            podwładni.Add(podwładny);
        }

        private static int? głębokośćPierwszegoKierownika = null;

        /*
        public override void WyświetlInformacje(int głębokość = 0)
        {
            if (głębokośćPierwszegoKierownika == null)
                głębokośćPierwszegoKierownika = głębokość;

            base.WyświetlInformacje(głębokość);
            if (podwładni.Count > 0)
            {
                zróbWcięcie(głębokość);
                Console.WriteLine("Podwładni:");
                foreach (Pracownik podwładny in podwładni)
                {
                    if (!podwładny.odwiedzony)
                        podwładny.WyświetlInformacje(głębokość + 1);
                    else Console.WriteLine("Wykryto cykl");
                }
                if (głębokość == głębokośćPierwszegoKierownika) Resetuj();
            }
        }
        */
        public override void PrzyjmijWizytę(IOdwiedzający odwiedzający, int głębokość = 0)
        {
            if (głębokośćPierwszegoKierownika == null)
                głębokośćPierwszegoKierownika = głębokość;

            base.PrzyjmijWizytę(odwiedzający, głębokość);
            if (podwładni.Count > 0)
            {
                zróbWcięcie(głębokość);
                Console.WriteLine("Podwładni:");
                foreach (Pracownik podwładny in podwładni)
                {
                    if (!podwładny.odwiedzony)
                        podwładny.PrzyjmijWizytę(odwiedzający, głębokość + 1);
                    else Console.WriteLine("Wykryto cykl");
                }
                if (głębokość == głębokośćPierwszegoKierownika) Resetuj();
            }
        }

        public override void Resetuj()
        {
            base.Resetuj();
            foreach (Pracownik podwładny in podwładni)
            {
                if (podwładny.odwiedzony) podwładny.Resetuj();
            }
        }
    }
}
