﻿using System;

namespace UMK.WzorceStrukturalne
{
    #region Klient i klasy używane przez niego
    class Punkt
    {
        public float X, Y;

        public Punkt(float x, float y)
        {
            X = x;
            Y = y;
        }        
    }

    //target, interfejs używany przez clienta
    interface IWielokątForemny
    {
        Punkt Środek { get; }
        int LiczbaBoków { get; }
        float DługośćBoków { get; }

        void WyświetlParametry();
        void WyświetlNazwęFigury();
        float ObliczObwód();
        float ObliczPole();
    }

    abstract class WielokątForemny : IWielokątForemny
    {
        public Punkt Środek { get; private set; }
        public int LiczbaBoków { get; private set; }
        public float DługośćBoków { get; private set; }

        protected WielokątForemny(Punkt środek, int liczbaBoków, float długośćBoków)
        {
            this.Środek = środek;
            this.LiczbaBoków = liczbaBoków;
            this.DługośćBoków = długośćBoków;
        }

        public virtual void WyświetlParametry()
        {
            Console.WriteLine("srodek: (" + Środek.X + "," + Środek.Y + "), liczba bokow: " + LiczbaBoków + ", dlugosc bokow: " + DługośćBoków);
        }

        public abstract void WyświetlNazwęFigury();

        public float ObliczObwód() //bez modyfikatora virtual - implementacja "ostateczna"
        {
            return LiczbaBoków * DługośćBoków;
        }

        public abstract float ObliczPole();
    }

    //przykład klasy zgodnej z targetem
    class TrójkątForemny : WielokątForemny
    {

        public TrójkątForemny(Punkt środek, float długośćBoków)
            : base(środek, 3, długośćBoków)
        { }

        public override void WyświetlNazwęFigury()
        {
            Console.Write("Trojkat rownoboczny");
        }

        public override float ObliczPole()
        {
            return DługośćBoków * DługośćBoków * (float)(Math.Sqrt(3.0) / 4.0);
        }
    };

    //client
    class Klient
    {
        public static void WyświetlInformacjeOFigurze(IWielokątForemny wielokątForemny)
        {
            wielokątForemny.WyświetlNazwęFigury();
            Console.WriteLine(":");
            wielokątForemny.WyświetlParametry();
            Console.WriteLine("Obwod: " + wielokątForemny.ObliczObwód());
            Console.WriteLine("Pole: " + wielokątForemny.ObliczPole());
            Console.WriteLine();
        }
    }
    #endregion

    #region Kod niepasujący, którego jednak chcemy użyć
    //adaptee, klasa adaptowana
    class Prostokąt
    {
        public Punkt P1 { get; private set; } //lewy-górny róg
        public Punkt P2 { get; private set; } //prawy-dolny róg	

        protected float szerokość() { return P2.X - P1.X; }
        protected float wysokość() { return P2.Y - P1.Y; }

        public Prostokąt(Punkt p1, Punkt p2)
        {
            this.P1 = p1;
            this.P2 = p2;

        }

        public void WyświetlNazwęFigury() //inna nazwa funkcji
        {
            Console.Write("Prostokat");
        }

        public void WyświetlParametry() //wyświetla inny rodzaj parametrów
        {
            Console.WriteLine("lewa krawędź: " + P1.X + ", górna krawędź: " + P1.Y + ", szerokość: " + szerokość() + ", wysokość: " + wysokość());
        }

        public float ObliczPole()
        {
            return szerokość() * wysokość();
        }
    }
    #endregion

    #region Nakładka dostosowująca kod niepasującego do targetu
    class ProstokątForemny : WielokątForemny
    {
        private Prostokąt prostokąt;

        /*
        private static Punkt obliczP1(Punkt środek, float długośćBoku)
        {
            return new Punkt(środek.X - długośćBoku / 2, środek.Y - długośćBoku / 2);
        }

        private static Punkt obliczP2(Punkt środek, float długośćBoku)
        {
            return new Punkt(środek.X + długośćBoku / 2, środek.Y + długośćBoku / 2);
        }
        */

        private static Punkt obliczŚrodek(Punkt p1, Punkt p2)
        {
            return new Punkt((p1.X + p2.X) / 2, (p1.Y + p2.Y) / 2);
        }

        private static float obliczDługośćBoku(Punkt p1, Punkt p2)
        {
            float dx = p2.X - p1.X;
            float dy = p2.Y - p1.Y;
            if (dx != dy) throw new Exception("Prostokąt foremny nie może mieć boków o różnej długości");
            return dx;
        }

        public ProstokątForemny(Prostokąt prostokąt)
            : base(obliczŚrodek(prostokąt.P1, prostokąt.P2), 4, obliczDługośćBoku(prostokąt.P1, prostokąt.P2))
        {
            this.prostokąt = prostokąt;
        }        

        /*
        public Punkt Środek
        {
            get
            {
                return new Punkt((p1.X + p2.X) / 2, (p1.Y + p2.Y) / 2);
            }
        }
        */

        //public float ObliczObwód() => 4 * DługośćBoków;

        public override void WyświetlNazwęFigury()
        {
            prostokąt.WyświetlNazwęFigury();
        }

        public override float ObliczPole()
        {
            return prostokąt.ObliczPole();
        }

        /*
        public float ObliczPole()
        {
            return base.ObliczPole();
        }
        */
    }
    #endregion
}
