﻿using System.Diagnostics;

namespace Kompozyt10
{
    public class Pracownik
    {
        private string imię, nazwisko, stanowisko;
        protected internal bool odwiedzony = false;

        public Pracownik(string imię, string nazwisko, string stanowisko)
        {
            this.imię = imię;
            this.nazwisko = nazwisko;
            this.stanowisko = stanowisko;
        }

        public virtual void WyświetlInformacje(int głębokość)
        {            
            zróbWcięcie(głębokość);
            Console.WriteLine($"{imię} {nazwisko} ({stanowisko})");
            odwiedzony = true;
        }

        protected void zróbWcięcie(int głębokość)
        {
            for (int i = 0; i < głębokość; i++) Console.Write(' ');
        }

        public void Resetuj()
        {
            odwiedzony = false;
        }
    }

    public class Kierownik : Pracownik
    {
        private List<Pracownik> podwładni = new List<Pracownik>();

        public Kierownik(string imię, string nazwisko, string stanowisko, Pracownik[]? podwładni = null)
            :base(imię, nazwisko, stanowisko)
        {
            if(podwładni != null && podwładni.Length > 0)
                this.podwładni.AddRange(podwładni);
        }

        public void DodajPodwładnego(Pracownik podwładny)
        {
            if(podwładni != null) podwładni.Add(podwładny);
        }

        private static int? głębokośćPierwszegoKierownika = null;

        public override void WyświetlInformacje(int głębokość)
        {
            if (głębokośćPierwszegoKierownika == null) głębokośćPierwszegoKierownika = głębokość;

            base.WyświetlInformacje(głębokość);
            zróbWcięcie(głębokość);
            Console.WriteLine("Podwładni:");
            foreach (Pracownik podwładny in podwładni)
            {
                if (!podwładny.odwiedzony)
                    podwładny.WyświetlInformacje(głębokość + 1);
                else Console.WriteLine("Wykryto cykl");
            }

            if (głębokość == głębokośćPierwszegoKierownika)
            {
                Resetuj();
            }

        }

        public void Resetuj()
        {
            base.Resetuj();
            foreach (Pracownik podwładny in podwładni)
                if (podwładny.odwiedzony)
                    podwładny.Resetuj();            
        }
    }
}
