﻿using System;

namespace Polecenie
{
    interface IPolecenie
    {
        public bool CzyMożnaWykonć();
        public void Wykonaj();
    }

    class PoleceniePrzelewu : IPolecenie
    {
        private Konto kontoPłatnika, kontoOdbiorcy;
        private decimal kwota;
        private bool wykonany = false;

        public PoleceniePrzelewu(Konto kontoPłatnika, Konto kontoOdbiorcy, decimal kwota)
        {
            this.kontoPłatnika = kontoPłatnika;
            this.kontoOdbiorcy = kontoOdbiorcy;
            this.kwota = kwota;
        }

        public bool CzyMożnaWykonć()
        {
            return !wykonany && kwota > 0;
        }

        public void Wykonaj()
        {
            if(!wykonany) Konto.Przelew(kontoPłatnika, kontoOdbiorcy, kwota);
            wykonany = true;
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            try //powinno być wokół każdego przelewu osobno
            {
                Konto konto1 = new Konto(1, 100);
                Konto konto2 = new Konto(2, 150);
                List<IPolecenie> polecenia = new List<IPolecenie>();

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //Konto.Przelew(konto1, konto2, 50);
                PoleceniePrzelewu przelew1 = new PoleceniePrzelewu(konto1, konto2, 50);
                polecenia.Add(przelew1);

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //Konto.Przelew(konto2, konto1, 100);
                PoleceniePrzelewu przelew2 = new PoleceniePrzelewu(konto2, konto1, 100);
                polecenia.Add(przelew2);

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //if (przelew1.CzyMożnaWykonć()) przelew1.Wykonaj();
                //if (przelew2.CzyMożnaWykonć()) przelew2.Wykonaj();                
                foreach (IPolecenie polecenie in polecenia)
                    if (polecenie.CzyMożnaWykonć())
                        polecenie.Wykonaj();

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
        }
    }
}
