﻿using System;

namespace Polecenie
{
    class Konto
    {
        private int numerKonta;
        private decimal saldo;

        public Konto(int numerKonta, decimal saldoPoczatkowe)
        {
            this.numerKonta = numerKonta;
            this.saldo = saldoPoczatkowe;
        }

        public void Wpłata(decimal kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            saldo += kwota;
            Console.WriteLine("Nastapila wplata na konto {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
        }

        public bool Wypłata(decimal kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            if (saldo >= kwota)
            {
                saldo -= kwota;
                Console.WriteLine("Nastapila wyplata z konta {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
                return true;
            }
            else return false;
        }

        public void WyświetlSaldo()
        {
            Console.WriteLine("Saldo konta {0:d}: {1:c}.", numerKonta, saldo);
        }

        public static bool Przelew(Konto kontoPłatnika, Konto kontoOdbiorcy, decimal kwota)
        {
            if (kontoPłatnika.numerKonta == kontoOdbiorcy.numerKonta) throw new Exception("Nie jest możliwe wykonanie przelewu na to samo konto");

            Console.WriteLine("Przygotowanie do przelewu z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);

            //niebezpieczne ze względu na dostęp z wielu wątków!!
            if (kontoPłatnika.Wypłata(kwota))
            {
                kontoOdbiorcy.Wpłata(kwota);
                Console.WriteLine("Wykonany zostal przelew z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);
                return true;
            }
            return false;
        }
    }
}
