﻿using System;

namespace MVC_Labirynt.Widok
{
    using Model;

    public class WidokLabiryntu
    {
        private IPobieranieInformacjiOLabiryncie model;

        public WidokLabiryntu(IPobieranieInformacjiOLabiryncie model)
        {
            this.model = model;
        }

        private int indeksBieżącejKomórkiModelu
        {
            get
            {
                return model.PobierzBieżącąKomórkę().PobierzIndeks();
            }
        }

        public static void WyświetlInformacjęOKomórce(Komórka komórka)
        {
            Console.WriteLine("Jestes w komorce " + komórka.PobierzIndeks() + ". Wybierz czynnosc (W, S, A, D, E)");
        }

        public void WyświetlInformacjęOBieżącejKomórce()
        {
            WyświetlInformacjęOKomórce(model.PobierzBieżącąKomórkę());
        }

        public static void WyświetlInformacjęOPróbiePrzejściaWKierunku(Kierunek kierunek)
        {
            switch (kierunek)
            {
                case Kierunek.Zachód:
                    Console.WriteLine("Proba przejscia na zachod");
                    break;
                case Kierunek.Wschód:
                    Console.WriteLine("Proba przejscia na wschod");
                    break;
                case Kierunek.Północ:
                    Console.WriteLine("Proba przejscia na polnoc");
                    break;
                case Kierunek.Południe:
                    Console.WriteLine("Proba przejscia na poludnie");
                    break;
            }

        }

        public void WyświetlInformacjęORezultaciePróbyPrzejścia(RezultatPróbyWejścia wynik)
        {
            switch (wynik)
            {
                case RezultatPróbyWejścia.Powodzenie:
                    Console.WriteLine("Przechodzisz do komorki " + indeksBieżącejKomórkiModelu);
                    break;
                case RezultatPróbyWejścia.Zamknięte:
                    Console.WriteLine("Niestety zamkniete. Musisz wpierw otworzyc");
                    break;
                case RezultatPróbyWejścia.NieMożnaWejść:
                    Console.WriteLine("Nie umiesz przechodzic przez sciany!");
                    break;
            }

        }

        public void WyświetlInformacjęOPróbieOtwarciaDrzwi()
        {
            Console.WriteLine("Probujesz otworzyc wszystkie drzwi w komorce " + indeksBieżącejKomórkiModelu);

        }

        public void WyświetlInformacjęORezultaciePróbyOtwarciaDrzwi(bool wynik)
        {
            if (wynik) Console.WriteLine("Otworzyles wszystkie drzwi w komorce " + indeksBieżącejKomórkiModelu);
            else Console.WriteLine("Niestety otwarcie drzwi w komorce " + indeksBieżącejKomórkiModelu + " nie powiodlo sie");
        }

        public void WyświetlInformacjęOStanieGry()
        {
            switch (model.PobierzStanGry())
            {
                case StanGry.Niezakończona:
                    break;
                case StanGry.Śmierć:
                    Console.WriteLine("Zabiles sie z rozpaczy!");
                    break;
                case StanGry.Wygrana:
                    Console.WriteLine("Dotarles do celu!");
                    break;
            }
        }
    }
}
