﻿namespace WzorceOperacyjne.Iterator
{
    //1. Klasa Stos - bez iteratora
    //2. Klasa StosIterator
    //3. Uzupelnic Stos
    //4. Przyklad użycia (operator ==)
    //5. Iterator - generic
    
    //Na początek czysta implementacja nie korzystająca z gotowych klas FCL
    //Zadanie do domu (po kompozycie): Stos : IEnumerable, własny IEnumerator

    class Stos
    {
        private int[] elementy = new int[10];
        private int liczbaElementów; //to raczej numer ostatniego elementu

        public Stos()
        {
            liczbaElementów = -1;
        }

        public Stos(Stos wzorzec) //konstruktor kopiujący, przyda się w przykładach
        {
            this.liczbaElementów = wzorzec.liczbaElementów;
            for (int i = 0; i < elementy.Length; ++i) this.elementy[i] = wzorzec.elementy[i];
        }

        public void Push(int nowyElement)
        {
            elementy[++liczbaElementów] = nowyElement;
        }
        public int Pop()
        {
            return elementy[liczbaElementów--];
        }
        public bool IsEmpty()
        {
            return (liczbaElementów == -1);
        }

        //!!!przygotować zagnieżdżoną klasę publiczną StosIterator

        //!!!przygotować wytwórczą metodę CreateIterator
    }
}
