﻿using System;
using System.Collections.Generic;

//kopia pliku ze wzorców strukturalnych (oryginal bez zadan domowych) - dodajemy IEnumerable<IPracownik>, który wymaga iteratora (IEnumerator)

//!!!zmiany trzeba wprowadzić w klasie Kierownik - ma implementować IEnumerable<IPracownik>

namespace WzorceStrukturalne.Kompozyt_1
{
    //Component
    public interface IPracownik
    {
        void WyświetlInformacje();
    }

    //Leaf
    public class Pracownik : IPracownik
    {
        private string imię, nazwisko, stanowisko;

        public Pracownik(string imię, string nazwisko, string stanowisko)
        {
            this.imię = imię;
            this.nazwisko = nazwisko;
            this.stanowisko = stanowisko;
        }

        public virtual void WyświetlInformacje()
        {
            Console.WriteLine(imię + " " + nazwisko + " (" + stanowisko + ")");
        }

        public override string ToString() //na potrzeby testów
        {
            return imię + " " + nazwisko + " (" + stanowisko + ")";
        }
    }

    //Composite
    public class Kierownik : Pracownik //!!!zaimplementować IEnumerable<IPracownik>
    {
        private List<IPracownik> podwładni = new List<IPracownik>();

        public Kierownik(string imię, string nazwisko, string stanowisko)
            : base(imię, nazwisko, stanowisko)
        { }

        public void DodajPodwładnego(IPracownik pracownik)
        {
            podwładni.Add(pracownik);
        }

        public override void WyświetlInformacje()
        {
            base.WyświetlInformacje();
            Console.WriteLine("Podwladni:");
            foreach (IPracownik podwładny in podwładni)
            {
                podwładny.WyświetlInformacje();
            }
        }

        //nie zadziała, jeżeli kompozyt zawiera cykle
        //tylko podwładni, kierownika nie będzie na liście
        private static List<IPracownik> twórzListęPodwałdnych(Kierownik kierownik)
        {
            List<IPracownik> podwładni = new List<IPracownik>();
            foreach (IPracownik podwładny in kierownik.podwładni)
            {        
                podwładni.Add(podwładny);
                if (podwładny is Kierownik) 
                    podwładni.AddRange(twórzListęPodwałdnych(podwładny as Kierownik));
            }
            return podwładni;
        }

        //!!!IEnumerator wymaga metod GetEnumerator zwracającej parametryczny i nieparametrycznego IEnumerator
    }
}
