﻿using System;
using System.Collections.Generic;

namespace WzorceOperacyjne.Odwiedzający
{
    //kopia z WzorceStrukturalne\Kompozyt.cs w podstawowej postaci

    //!!!zdefiniować interfejs IOdwiedzany

    //Component, Element
    public interface IPracownik
    {
        void WyświetlInformacje();
    }

    //Leaf, ConcreteElement
    public class Pracownik : IPracownik //, IOdwiedzany
    {
        private string imię, nazwisko, stanowisko;

        public Pracownik(string imię, string nazwisko, string stanowisko)
        {
            this.imię = imię;
            this.nazwisko = nazwisko;
            this.stanowisko = stanowisko;
        }

        public virtual void WyświetlInformacje()
        {
            Console.WriteLine(imię + " " + nazwisko + " (" + stanowisko + ")");
        }
    
        //!!!interfejs IOdwiedzany wymaga metody PrzyjmijWizytę
    }

    //Composite
    public class Kierownik : Pracownik
    {
        private List<IPracownik> podwładni = new List<IPracownik>();

        public Kierownik(string imię, string nazwisko, string stanowisko)
            : base(imię, nazwisko, stanowisko)
        { }

        public void DodajPodwładnego(IPracownik pracownik)
        {
            podwładni.Add(pracownik);
        }

        public override void WyświetlInformacje()
        {
            base.WyświetlInformacje();
            Console.WriteLine("Podwladni:");
            foreach (IPracownik podwładny in podwładni)
            {
                podwładny.WyświetlInformacje();
            }
        }

        //!!!nadpisanie metody PrzyjmujWizytę
    }

    //-------------------------------------

    //!!!trzeba zdefiniować interejs IOdwiedzający i implementujące go klasy OdwiedzającyZliczający i OdwiedzającyWyświetlającyInformacje
}
