﻿using System;

//!!!adapter zdefiniować w ostatnim regionie zdefiniowanym w tym pliku

namespace WzorceStrukturalne.AdapterKlasowy
{
    #region Klasy wokół klienta
    class Punkt
    {
        public float X, Y;

        public Punkt(float x, float y)
        {
            X = x;
            Y = y;
        }
    }

    //target, interfejs używany przez clienta
    interface IWielokątForemny
    {
        Punkt Środek { get; set; }
        int LiczbaBoków { get; set; }
        float DługośćBoków { get; set; }

        void WyświetlParametry();
        void WyświetlNazwęFigury();
        float ObliczObwód();
        float ObliczPole();
    }

    abstract class WielokątForemny : IWielokątForemny
    {
        public Punkt Środek { get; set; }
        public int LiczbaBoków { get; set; }
        public float DługośćBoków { get; set; }

        protected WielokątForemny(Punkt środek, int liczbaBoków, float długośćBoków)
        {
            this.Środek = środek;
            this.LiczbaBoków = liczbaBoków;
            this.DługośćBoków = długośćBoków;
        }

        public virtual void WyświetlParametry()
        {
            Console.WriteLine("srodek: (" + Środek.X + "," + Środek.Y + "), liczba bokow: " + LiczbaBoków + ", dlugosc bokow: " + DługośćBoków);
        }

        public abstract void WyświetlNazwęFigury();

        public float ObliczObwód() //bez virtual, bo implementacja "ostateczna"
        {
            return LiczbaBoków * DługośćBoków;
        }

        public abstract float ObliczPole();   
    }

    //przykład klasy zgodnej z targetem
    class TrójkątForemny : WielokątForemny
    {

        public TrójkątForemny(Punkt środek, float długośćBoków)
            : base(środek, 3, długośćBoków)
        { }

        public override void WyświetlNazwęFigury()
        {
            Console.Write("Trojkat rownoboczny");
        }

        public override float ObliczPole()
        {
            return DługośćBoków * DługośćBoków * (float)(Math.Sqrt(3.0) / 4.0);
        }
    };

    //client
    class Klient
    {
        public static void WyświetlInformacjeOFigurze(IWielokątForemny wielokątForemny)
        {
            wielokątForemny.WyświetlNazwęFigury();
            Console.WriteLine(":");
            wielokątForemny.WyświetlParametry();
            Console.WriteLine("Obwod: " + wielokątForemny.ObliczObwód());
            Console.WriteLine("Pole: " + wielokątForemny.ObliczPole());
            Console.WriteLine();
        }
    }
    #endregion

    #region Kod niepasujący, którego chcemy jednak użyć
    //adaptee, klasa adaptowana
    class Prostokąt
    {
        private Punkt p1; //lewy-górny róg
        private Punkt p2; //prawy-dolny róg	

        private float szerokość() { return p2.X - p1.X; }
        private float wysokość() { return p2.Y - p1.Y; }

        public Prostokąt(Punkt p1, Punkt p2)
        {
            this.p1 = p1;
            this.p2 = p2;

        }

        public void WyświetlNazwęFigury() //inna nazwa funkcji
        {
            Console.Write("Prostokat");
        }

        public virtual void WyświetlParametry() //wyświetla inny rodzaj parametrów
        {
            Console.WriteLine("lewa krawędź: " + p1.X + ", górna krawędź: " + p1.Y + ", szerokość: " + szerokość() + ", wysokość: " + wysokość());
        }

        public float ObliczPole()
        {
            return szerokość() * wysokość();
        }
    }
    #endregion

    #region Nakładka dostosowująca kod niepasującego do targetu
    //adapter, klasa adaptująca klasę adaptowaną do targetu
    //idea: użyć klasy Prostokąt, ale adaptując ją do schematu narzuconego przez interfejs IWielokątForemny
    //Uwaga! W C# nie można poprzez dziedziczenie wykorzystać klasy WielokątForemny, bo nie ma dziedziczenia wielobazowego

    //!!!zdefiniować klasę: class ProstokątForemny : Prostokąt, IWielokątForemny
    #endregion
}
