﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SOLID
{
    //using SPR.After.Widok;

    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            SPR.Before.Prostokąt prostokąt = new SPR.Before.Prostokąt(200, 100, 5, 4);
            SPR.Before.Okrąg okrąg = new SPR.Before.Okrąg(270, 100, 2);
            SPR.Before.TrójkątRównoboczny trójkąt = new SPR.Before.TrójkątRównoboczny(320, 100, 5);

            textBox1.Clear();
            textBox1.Text += "Prostokąt: pole: " + prostokąt.Pole + ", obwód: " + prostokąt.Obwód + Environment.NewLine;
            textBox1.Text += "Okrąg: pole: " + okrąg.Pole + ", obwód: " + okrąg.Obwód + Environment.NewLine;
            textBox1.Text += "Trójkąt równoboczny: pole: " + trójkąt.Pole + ", obwód: " + trójkąt.Obwód + Environment.NewLine;
            
            Graphics g = this.CreateGraphics();
            prostokąt.Rysuj(g, Color.Navy, 10, true);
            okrąg.Rysuj(g, Color.Navy, 10, true);
            trójkąt.Rysuj(g, Color.Navy, 10, true);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            SPR.Before.IFigura[] figury = new SPR.Before.IFigura[3] 
            { 
                new SPR.Before.Prostokąt(200, 100, 5, 4),
                new SPR.Before.Okrąg(270, 100, 2),
                new SPR.Before.TrójkątRównoboczny(320, 100, 5)
            };

            textBox1.Clear();
            Graphics g = this.CreateGraphics();
            foreach (SPR.Before.IFigura figura in figury)
            {
                textBox1.Text += figura.GetType().Name + ", pole: " + figura.Pole + ", obwód: " + figura.Obwód + Environment.NewLine;
                figura.Rysuj(g, Color.Navy, 10, true);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            object[] figury = new object[5]
            {
                new OCP.Before.Prostokąt(1,1),
                new OCP.Before.Okrąg(1),
                new OCP.Before.Prostokąt(2,1),
                new OCP.Before.Prostokąt(3,1),
                new OCP.Before.Okrąg(3)
            };
            double sumaPól = OCP.Before.SumatorPólFigur.SumujPolaFigur(figury);
            textBox2.Text = "Suma pól: " + sumaPól.ToString();
        }

        private void button7_Click(object sender, EventArgs e)
        {
            double pp = LSP.Before.PomocnikObliczeń.ZmieńBokiIObliczPole(new LSP.Before.Prostokąt(), 2, 3);
            double pk = LSP.Before.PomocnikObliczeń.ZmieńBokiIObliczPole(new LSP.Before.Kwadrat(), 2, 3);
            textBox3.Text = "Pole (prostokąt): " + pp.ToString() + ", pole (kwadrat): " + pk.ToString();
        }

        private void button8_Click(object sender, EventArgs e)
        {
            ISP.Before.Prostokąt[] figury = new ISP.Before.Prostokąt[3]
            {
                new ISP.Before.Prostokąt(1,1),
                new ISP.Before.Prostokąt(2,1),
                new ISP.Before.Prostokąt(3,2)
            };
            double sumaPól = ISP.Before.SumatorPólFigur.ObliczSumęPól(figury);
            textBox4.Text = "Suma pól: " + sumaPól.ToString();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            DIP.Before.Opakowanie opakowanie = new DIP.Before.Opakowanie(3, 2);
            double pole = opakowanie.ObliczPole();
            textBox5.Text = "Pole: " + pole.ToString();
        }
    }
}
