﻿using System.Collections.Generic;

namespace SOLID.ISP.Before
{
    public interface IFigura
    {
        double Pole { get; }
        double Obwód { get; }
    }

    public class Prostokąt : IFigura
    {
        private double a, b;

        public Prostokąt(double a, double b)
        {
            this.a = a; this.b = b;
        }

        public double Pole
        {
            get { return a * b; }
        }

        public double Obwód
        {
            get { return 2 * a + 2 * b; }
        }
    }

    public static class SumatorPólFigur
    {
        public static double ObliczSumęPól(IEnumerable<IFigura> figury)
        {
            double sumaPól = 0;
            foreach (IFigura figura in figury) sumaPól += figura.Pole;
            return sumaPól;
        }
    }

    public static class SumatorObwodówFigur
    {
        public static double ObliczSumęObwodów(IEnumerable<IFigura> figury)
        {
            double sumaObwodów = 0;
            foreach (IFigura figura in figury) sumaObwodów += figura.Obwód;
            return sumaObwodów;
        }
    }
}
