﻿namespace SOLID.LSP.Before
{
    public class Prostokąt
    {
        protected double a = 0, b = 0;

        public virtual double A
        {
            get { return a; }
            set { a = value; }
        }

        public virtual double B
        {
            get { return b; }
            set { b = value; }
        }

        public double Pole
        {
            get { return a * b; }
        }
    }

    public class Kwadrat : Prostokąt 
    {
        public override double A
        {
            get { return a; }
            set { a = value; b = value; } //użytkownik nie spodziewa się takiego związania zmiennych
        }

        public override double B
        {
            get { return b; }
            set { a = value; b = value; }
        }
    }

    //Kwadrat nie powinien być klasą potomną względem Prostokąta. Zmniejsza jego funkcjonalność, zamiast rozszerzać.

    public static class PomocnikObliczeń
    {
        public static double ZmieńBokiIObliczPole(Prostokąt prostokąt, double a, double b)
        {
            prostokąt.A = a;
            prostokąt.B = b;
            return prostokąt.Pole;
        }
    }
}
