﻿using System;

namespace SOLID.OCP.Before
{
    public class Prostokąt
    {
        public double A { get; private set; }
        public double B { get; private set; }

        public Prostokąt(double a, double b)
        {
            A = a; B = b;
        }
    }

    public class Okrąg
    {
        public double R{ get; private set; }

        public Okrąg(double r)
        {
            R = r;
        }
    }

    public static class SumatorPólFigur
    {
        public static double SumujPolaFigur(object[] figury)
        {
            double sumaPól = 0;
            foreach(object figura in figury)
            {
                if(figura is Prostokąt)
                {
                    Prostokąt prostokąt = figura as Prostokąt;
                    sumaPól += prostokąt.A * prostokąt.B;
                }
                if(figura is Okrąg)
                {
                    Okrąg okrąg = figura as Okrąg;
                    sumaPól += Math.PI * okrąg.R * okrąg.R;
                }
            }
            return sumaPól;
        }
    }
}
