﻿using System;

namespace SOLID.SPR.Before
{
    using System.Drawing;

    public interface IFigura
    {
        double Pole { get; }
        double Obwód { get; }
        void Rysuj(Graphics g, Color kolor, double skala = 1, bool wypełnij = false);
    }

    public class Prostokąt : IFigura
    {
        private int x, y;
        private double a, b;

        public Prostokąt(int x, int y, double a, double b)
        {
            this.x = x; this.y = y;
            this.a = a; this.b = b;
        }

        public double Pole
        {
            get { return a * b; }
        }

        public double Obwód
        {
            get { return 2 * a + 2 * b; }
        }

        //mieszanie interfejsu z modelem
        public void Rysuj(Graphics g, Color kolor, double skala = 1, bool wypełnij = false)
        {
            int w = (int)(skala * a);
            int h = (int)(skala * b);
            if (!wypełnij) g.DrawRectangle(new Pen(kolor), x, y, w, h);
            else g.FillRectangle(new SolidBrush(kolor), x, y, w, h);
        }
    }

    public class Okrąg : IFigura
    {
        private int x, y;
        private double r;

        public Okrąg(int x, int y, double r)
        {
            this.x = x; this.y = y;
            this.r = r;
        }

        public double Pole
        {
            get { return Math.PI * r * r; }
        }

        public double Obwód
        {
            get { return 2 * Math.PI * r; }
        }

        //mieszanie interfejsu z modelem
        public void Rysuj(Graphics g, Color kolor, double skala = 1, bool wypełnij = false)
        {
            int d = (int)(skala * 2 * r);
            if (!wypełnij) g.DrawEllipse(new Pen(kolor), x, y, d, d);
            else g.FillEllipse(new SolidBrush(kolor), x, y, d, d);
        }
    }

    public class TrójkątRównoboczny : IFigura
    {
        private int x, y;
        private double a, h;

        public TrójkątRównoboczny(int x, int y, double a)
        {
            this.x = x; this.y = y;
            this.a = a; this.h = a * Math.Sqrt(3.0) / 2.0;
        }

        public double Pole
        {
            get { return a * h / 2; }
        }

        public double Obwód
        {
            get { return 3 * a; }
        }

        //mieszanie interfejsu z modelem
        public void Rysuj(Graphics g, Color kolor, double skala = 1, bool wypełnij = false)
        {
            int ia = (int)(skala * a), ih = (int)(skala * h);
            Point[] punkty = new Point[3] { new Point(x, y + ih), new Point(x + ia, y + ih), new Point(x + ia / 2, y) };
            if (!wypełnij) g.DrawPolygon(new Pen(kolor), punkty);
            else g.FillPolygon(new SolidBrush(kolor), punkty);
        }
    }
}