﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Wąż
{
    class Program
    {
        enum StanGry { Trwa = -1, Przegrana = 0, WszystkieOwoceZjedzone = 1 };

        static readonly int szerokość = Console.WindowWidth - 2;
        static readonly int wysokość = Console.WindowHeight - 3;
        static readonly int liczbaPól = szerokość * wysokość;
        static readonly int początkowaLiczbaOwoców = liczbaPól / 10;
        static readonly int początkowaLiczbaPułapek = liczbaPól / 10;

        static readonly bool pułapkiToTylkoPrzeszkody = false; //blokuje także najechanie głowy na ciało węża

        const char znak = '#';
        static readonly ConsoleColor domyślnyKolorZnaku = Console.ForegroundColor;

        private struct WspółrzędnePola
        {
            public int x, y;

            public WspółrzędnePola(int x, int y)
            {
                this.x = x;
                this.y = y;
            }
        }

        static void RysujPlanszę()
        {
            Console.Clear();
            Console.ForegroundColor = ConsoleColor.White;
            for (int kolumna = 0; kolumna < Console.WindowWidth; kolumna++)
            {
                Console.SetCursorPosition(kolumna, 0);
                Console.Write(znak);

                Console.SetCursorPosition(kolumna, Console.WindowHeight - 2);
                Console.Write(znak);
            }

            for (int wiersz = 0; wiersz < Console.WindowHeight - 1; wiersz++)
            {
                Console.SetCursorPosition(0, wiersz);
                Console.Write(znak);

                Console.SetCursorPosition(Console.WindowWidth - 1, wiersz);
                Console.Write(znak);
            }
            Console.ForegroundColor = domyślnyKolorZnaku;
        }

        //nie używane
        static bool SprawdźCzyPoleZnajdujeSięWObrębiePlanszy(WspółrzędnePola pole)
        {
            return !(pole.x < 0 || pole.x >= szerokość || pole.y < 0 || pole.y >= wysokość);
        }

        static void UstalPołożeniePolaNaPlanszy(WspółrzędnePola pole)
        {
            Console.SetCursorPosition(1 + pole.x, 1 + pole.y);
        }

        static void ZaznaczPole(WspółrzędnePola pole)
        {
            UstalPołożeniePolaNaPlanszy(pole);
            Console.Write(znak);
        }

        static void RysujZListy(List<WspółrzędnePola> lista, ConsoleColor kolor)
        {
            Console.ForegroundColor = kolor;
            for (int i = 0; i < lista.Count; ++i)
            {
                UstalPołożeniePolaNaPlanszy(lista[i]);
                Console.Write(znak);
            }
            Console.ForegroundColor = domyślnyKolorZnaku;
        }

        static void RysujWęża(List<WspółrzędnePola> wąż)
        {
            RysujZListy(wąż, ConsoleColor.DarkYellow);

            WspółrzędnePola głowa = wąż.Last();
            Console.ForegroundColor = ConsoleColor.Yellow;
            ZaznaczPole(głowa);
            Console.ForegroundColor = domyślnyKolorZnaku;
        }

        static void RysujOwoce(List<WspółrzędnePola> owoce)
        {
            RysujZListy(owoce, ConsoleColor.Green);
        }

        static void RysujPułapki(List<WspółrzędnePola> pułapki)
        {
            RysujZListy(pułapki, pułapkiToTylkoPrzeszkody ? ConsoleColor.White : ConsoleColor.Red);
        }

        static void PilnujDługościWęża(List<WspółrzędnePola> wąż, int maksymalnaDługośćWęża)
        {
            int ileNadmiarowych = wąż.Count - maksymalnaDługośćWęża;
            if (ileNadmiarowych > 0)
                wąż.RemoveRange(0, ileNadmiarowych);
        }

        static void Podpis(List<WspółrzędnePola> wąż, List<WspółrzędnePola> owoce, List<WspółrzędnePola> pułapki,bool wBieżącejLinii = false)
        {
            if(!wBieżącejLinii) Console.SetCursorPosition(0, Console.WindowHeight - 1);

            Console.ForegroundColor = ConsoleColor.DarkYellow;
            Console.Write("Długość węża: ");
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.Write(wąż.Count);

            Console.Write("     ");

            Console.ForegroundColor = ConsoleColor.DarkGreen;
            Console.Write("Liczba owoców: ");
            Console.ForegroundColor = ConsoleColor.Green;
            Console.Write(owoce.Count);
            Console.ForegroundColor = ConsoleColor.DarkGreen;
            Console.Write(" / " + początkowaLiczbaOwoców);

            Console.Write("     ");

            Console.ForegroundColor = ConsoleColor.DarkRed;
            Console.Write("Liczba pułapek: ");
            Console.ForegroundColor = ConsoleColor.Red;
            Console.Write(pułapki.Count);

            Console.ForegroundColor = domyślnyKolorZnaku;
        }

        static bool CzyGłowaWężaUgryzłaJegoCiało(List<WspółrzędnePola> wąż, WspółrzędnePola głowa)
        {
            if (wąż.Count == 1) return false;
            if (wąż.IndexOf(głowa) < 0) return false;
            return wąż.IndexOf(głowa) != (wąż.Count - 1); //położenie głowy nie jest ostatnie na liście
        }

        static void Main(string[] args)
        {
            StanGry wynikGry = StanGry.Trwa;
            int maksymalnaDlugoscWeza = 10;
            List<WspółrzędnePola> wąż = new List<WspółrzędnePola>();
            wąż.Add(new WspółrzędnePola(szerokość / 2, wysokość / 2));

            Random r = new Random();
            List<WspółrzędnePola> owoce = new List<WspółrzędnePola>(początkowaLiczbaOwoców);
            for (int i = 0; i < początkowaLiczbaOwoców; ++i)
            {
                WspółrzędnePola nowyOwoc;
                do
                {
                    nowyOwoc = new WspółrzędnePola(r.Next(szerokość), r.Next(wysokość));
                }
                while (owoce.Contains(nowyOwoc) || wąż.Contains(nowyOwoc));
                owoce.Add(nowyOwoc);
            }

            List<WspółrzędnePola> pułapki = new List<WspółrzędnePola>(początkowaLiczbaPułapek);
            for (int i = 0; i < początkowaLiczbaPułapek; ++i)
            {
                WspółrzędnePola nowaPułapka;
                do
                {
                    nowaPułapka = new WspółrzędnePola(r.Next(szerokość), r.Next(wysokość));
                }
                while (pułapki.Contains(nowaPułapka) || owoce.Contains(nowaPułapka) || wąż.Contains(nowaPułapka));
                pułapki.Add(nowaPułapka);
            }

            ConsoleKey klawisz;
            do
            {
                PilnujDługościWęża(wąż, maksymalnaDlugoscWeza);

                RysujPlanszę();                
                RysujOwoce(owoce);
                RysujPułapki(pułapki);
                RysujWęża(wąż);
                Podpis(wąż, owoce, pułapki);

                WspółrzędnePola głowa = wąż.Last();
                klawisz = Console.ReadKey().Key;
                WspółrzędnePola? nowePołożenieGłowy = null;
                switch (klawisz)
                {
                    case ConsoleKey.LeftArrow:
                        nowePołożenieGłowy = new WspółrzędnePola(głowa.x - 1, głowa.y);
                        break;
                    case ConsoleKey.RightArrow:
                        nowePołożenieGłowy = new WspółrzędnePola(głowa.x + 1, głowa.y);
                        break;
                    case ConsoleKey.UpArrow:
                        nowePołożenieGłowy = new WspółrzędnePola(głowa.x, głowa.y - 1);
                        break;
                    case ConsoleKey.DownArrow:
                        nowePołożenieGłowy = new WspółrzędnePola(głowa.x, głowa.y + 1);
                        break;
                }

                if (nowePołożenieGłowy.HasValue && !SprawdźCzyPoleZnajdujeSięWObrębiePlanszy(nowePołożenieGłowy.Value)) nowePołożenieGłowy = null;
                if (nowePołożenieGłowy.HasValue && pułapkiToTylkoPrzeszkody && pułapki.Contains(nowePołożenieGłowy.Value)) nowePołożenieGłowy = null;
                if (nowePołożenieGłowy.HasValue && pułapkiToTylkoPrzeszkody && CzyGłowaWężaUgryzłaJegoCiało(wąż, nowePołożenieGłowy.Value)) nowePołożenieGłowy = null;

                if (nowePołożenieGłowy.HasValue)
                {
                    głowa = nowePołożenieGłowy.Value;
                    wąż.Add(głowa);

                    if (owoce.Contains(głowa))
                    {
                        maksymalnaDlugoscWeza++;
                        owoce.Remove(głowa);
                    }
                    if (pułapki.Contains(głowa) || CzyGłowaWężaUgryzłaJegoCiało(wąż, głowa))
                    {
                        wynikGry = StanGry.Przegrana;
                        
                        break;
                    }

                    if (owoce.Count == 0)
                    {
                        wynikGry = StanGry.WszystkieOwoceZjedzone;
                        break;
                    }
                }
            }
            while (klawisz != ConsoleKey.Escape);

            //Console.ReadLine();       
            Console.Clear();
            Console.ForegroundColor = ConsoleColor.White;
            Console.WriteLine("Koniec gry.");
            switch (wynikGry)
            {
                case StanGry.Przegrana:
                    Console.ForegroundColor = ConsoleColor.Red;
                    Console.WriteLine("Przegrałeś!!");
                    break;
                case StanGry.WszystkieOwoceZjedzone:
                    Console.ForegroundColor = ConsoleColor.Green;
                    Console.WriteLine("Wszystkie owoce zjedzone! Wygrałeś!!");
                    break;
                default:                    
                    Console.WriteLine("Gra zakończona przez użytkownika.");
                    break;
            }
            Podpis(wąż, owoce, pułapki, true); Console.WriteLine();
            Console.ForegroundColor = domyślnyKolorZnaku;
            Console.WriteLine();
        }
    }
}
