﻿using System;

namespace UMK.WzorceOperacyjne
{
    //https://sourcemaking.com/design_patterns/observer/cpp/1

    class Dzielenie
    {
        private int wartość = 0;
        private int dzielnik;

        public Dzielenie(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna / dzielnik;
            Console.WriteLine("{0} / {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Modulo
    {
        private int wartość = 0;
        private int dzielnik;

        public Modulo(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna % dzielnik;
            Console.WriteLine("{0} % {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Podmiot
    {
        private int wartość;
        private Dzielenie dzielenie; //obiekty, których stan zależy od zmieniającego się pola wartość
        private Modulo modulo;

        private void powiadom()
        {
            dzielenie.Aktualizuj(wartość);
            modulo.Aktualizuj(wartość);
        }

        public Podmiot()
        {
            wartość = 0;
            dzielenie = new Dzielenie(3);
            modulo = new Modulo(3);
        }

        public void ZmieńWartość(int nowaWartość)
        {
            wartość = nowaWartość;
            powiadom();
        }
    }
}